/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.model.index.file;

import com.google.common.collect.Maps;
import com.google.common.io.Closeables;
import com.google.common.io.NullOutputStream;
import de.innosystec.unrar.Archive;
import de.innosystec.unrar.exception.RarException;
import de.innosystec.unrar.rarfile.FileHeader;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.docfetcher.model.Path;
import net.sourceforge.docfetcher.model.TreeNode;
import net.sourceforge.docfetcher.model.index.IndexingConfig;
import net.sourceforge.docfetcher.model.index.IndexingError;
import net.sourceforge.docfetcher.model.index.file.ArchiveEncryptedException;
import net.sourceforge.docfetcher.model.index.file.SolidArchiveTree;
import net.sourceforge.docfetcher.util.Util;

final class RarTree
extends SolidArchiveTree<FileHeader> {
    public RarTree(File file, IndexingConfig indexingConfig, Path path, SolidArchiveTree.FailReporter failReporter) throws IOException, ArchiveEncryptedException {
        super(file, indexingConfig, path, failReporter);
    }

    public RarTree(File file, IndexingConfig indexingConfig, boolean bl, Path path, SolidArchiveTree.FailReporter failReporter) throws IOException, ArchiveEncryptedException {
        super(file, indexingConfig, bl, path, failReporter);
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    protected SolidArchiveTree.ArchiveIterator<FileHeader> getArchiveIterator(File file, String string) throws IOException, ArchiveEncryptedException {
        Archive archive = null;
        try {
            archive = new Archive(file);
            if (archive.isEncrypted()) {
                Closeables.closeQuietly((Closeable)archive);
                throw new ArchiveEncryptedException(file, string);
            }
            final Archive archive2 = archive;
            return new SolidArchiveTree.ArchiveIterator<FileHeader>(){
                private FileHeader nextFileHeader;
                {
                    this.nextFileHeader = archive2.nextFileHeader();
                }

                @Override
                public FileHeader next() {
                    FileHeader fileHeader = this.nextFileHeader;
                    this.nextFileHeader = archive2.nextFileHeader();
                    return fileHeader;
                }

                @Override
                public boolean hasNext() {
                    return this.nextFileHeader != null;
                }

                @Override
                public void finished() {
                    Closeables.closeQuietly((Closeable)archive2);
                }
            };
        }
        catch (RarException rarException) {
            Closeables.closeQuietly(archive);
            throw new IOException(rarException);
        }
        catch (RuntimeException runtimeException) {
            Closeables.closeQuietly(archive);
            throw new IOException(runtimeException);
        }
    }

    @Override
    protected SolidArchiveTree.ArchiveEntryReader<FileHeader> getArchiveEntryReader() {
        return RarEntryReader.instance;
    }

    @Override
    protected Map<Integer, File> doUnpack(Map<Integer, TreeNode> map, SolidArchiveTree.TempFileFactory tempFileFactory) throws IOException {
        HashMap hashMap;
        HashMap hashMap2 = Maps.newHashMap();
        Archive archive = null;
        try {
            archive = new Archive(this.archiveFile);
            boolean bl = RarTree.isSolidRarArchive(archive);
            FileHeader fileHeader = null;
            NullOutputStream nullOutputStream = bl ? new NullOutputStream() : null;
            int n = 0;
            while (!map.isEmpty() && (fileHeader = archive.nextFileHeader()) != null) {
                block13: {
                    if (!fileHeader.isDirectory() && !fileHeader.isEncrypted()) {
                        TreeNode treeNode = map.remove(n);
                        try {
                            if (treeNode != null) {
                                File file = tempFileFactory.createTempFile(treeNode);
                                FileOutputStream fileOutputStream = new FileOutputStream(file);
                                archive.extractFile(fileHeader, (OutputStream)fileOutputStream);
                                Closeables.closeQuietly((Closeable)fileOutputStream);
                                hashMap2.put(n, file);
                            } else if (bl) {
                                archive.extractFile(fileHeader, (OutputStream)nullOutputStream);
                            }
                        }
                        catch (OutOfMemoryError outOfMemoryError) {
                            if (treeNode != null) {
                                this.failReporter.fail(IndexingError.ErrorType.OUT_OF_MEMORY, treeNode, outOfMemoryError);
                            }
                        }
                        catch (Exception exception) {
                            if (treeNode == null) break block13;
                            this.failReporter.fail(IndexingError.ErrorType.ARCHIVE_ENTRY, treeNode, exception);
                        }
                    }
                }
                ++n;
            }
            hashMap = hashMap2;
        }
        catch (RarException rarException) {
            try {
                throw new IOException(rarException);
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(archive);
                throw throwable;
            }
        }
        Closeables.closeQuietly((Closeable)archive);
        return hashMap;
    }

    private static boolean isSolidRarArchive(Archive archive) {
        for (FileHeader fileHeader : archive.getFileHeaders()) {
            if (!fileHeader.isSolid()) continue;
            return true;
        }
        return false;
    }

    private static final class RarEntryReader
    implements SolidArchiveTree.ArchiveEntryReader<FileHeader> {
        private static final RarEntryReader instance = new RarEntryReader();

        private RarEntryReader() {
        }

        @Override
        public String getInnerPath(FileHeader fileHeader) {
            String string = "".equals(fileHeader.getFileNameW()) ? fileHeader.getFileNameString() : fileHeader.getFileNameW();
            return Util.toForwardSlashes(string);
        }

        @Override
        public boolean isDirectory(FileHeader fileHeader) {
            return fileHeader.isDirectory();
        }

        @Override
        public long getLastModified(FileHeader fileHeader) {
            return fileHeader.getMTime().getTime();
        }

        @Override
        public long getUnpackedSize(FileHeader fileHeader) {
            return fileHeader.getFullUnpackSize();
        }

        @Override
        public boolean isEncrypted(FileHeader fileHeader) {
            return fileHeader.isEncrypted();
        }
    }
}

