/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.model.index.file;

import SevenZip.Archive.IArchiveExtractCallback;
import SevenZip.Archive.IInArchive;
import com.google.common.io.NullOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import net.sourceforge.docfetcher.util.Util;

abstract class SevenZipUnpacker<T> {
    private static final int mode = 0;
    private final IInArchive archive;

    public SevenZipUnpacker(IInArchive iInArchive) {
        Util.checkNotNull(iInArchive);
        this.archive = iInArchive;
    }

    public final T unpack(int ... nArray) throws IOException {
        Arrays.sort(nArray);
        Callback callback = new Callback(nArray);
        this.archive.Extract(nArray, nArray.length, 0, (IArchiveExtractCallback)callback);
        return this.getUnpackResult();
    }

    public abstract File getOutputFile(int var1) throws IOException;

    public abstract T getUnpackResult();

    private class Callback
    implements IArchiveExtractCallback {
        private final int[] indices;

        public Callback(int[] nArray) {
            this.indices = Util.checkNotNull(nArray);
        }

        public int GetStream(int n, OutputStream[] outputStreamArray, int n2) throws IOException {
            outputStreamArray[0] = Arrays.binarySearch(this.indices, n) < 0 ? new NullOutputStream() : new FileOutputStream(SevenZipUnpacker.this.getOutputFile(n));
            return 0;
        }

        public final int PrepareOperation(int n) {
            return 0;
        }

        public final int SetCompleted(long l) {
            return 0;
        }

        public final int SetOperationResult(int n) throws IOException {
            return 0;
        }

        public final int SetTotal(long l) {
            return 0;
        }
    }
}

