/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.model.index.file;

import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sourceforge.docfetcher.enums.ProgramConf;
import net.sourceforge.docfetcher.model.Folder;
import net.sourceforge.docfetcher.model.Path;
import net.sourceforge.docfetcher.model.TreeNode;
import net.sourceforge.docfetcher.model.index.DiskSpaceException;
import net.sourceforge.docfetcher.model.index.IndexingConfig;
import net.sourceforge.docfetcher.model.index.IndexingError;
import net.sourceforge.docfetcher.model.index.IndexingException;
import net.sourceforge.docfetcher.model.index.PatternAction;
import net.sourceforge.docfetcher.model.index.file.ArchiveEncryptedException;
import net.sourceforge.docfetcher.model.index.file.FileDocument;
import net.sourceforge.docfetcher.model.index.file.FileFolder;
import net.sourceforge.docfetcher.model.index.file.HtmlUtil;
import net.sourceforge.docfetcher.model.parse.ParseService;
import net.sourceforge.docfetcher.util.Util;
import net.sourceforge.docfetcher.util.collect.LazyList;
import net.sourceforge.docfetcher.util.collect.SafeKeyMap;

abstract class SolidArchiveTree<E>
implements Closeable {
    private final FileFolder archiveFolder;
    private final SafeKeyMap<Path, EntryData> entryDataMap = SafeKeyMap.createHashMap();
    private final TempFileFactory defaultTempFileFactory = new TempFileFactory();
    private final IndexingConfig config;
    protected final FailReporter failReporter;
    protected final File archiveFile;

    public SolidArchiveTree(File file, IndexingConfig indexingConfig, Path path, FailReporter failReporter) throws IOException, ArchiveEncryptedException {
        this(file, indexingConfig, indexingConfig.isHtmlPairing(), path, failReporter);
    }

    public SolidArchiveTree(File file, final IndexingConfig indexingConfig, boolean bl, Path path, FailReporter failReporter) throws IOException, ArchiveEncryptedException {
        Util.checkNotNull(file, indexingConfig);
        this.archiveFile = file;
        this.config = indexingConfig;
        this.failReporter = failReporter == null ? new NullFailReporter() : failReporter;
        Path path2 = path == null ? indexingConfig.getStorablePath(file) : path;
        this.archiveFolder = new FileFolder(path2, null);
        ArchiveIterator<E> archiveIterator = this.getArchiveIterator(file, path2.getPath());
        ArchiveEntryReader<E> archiveEntryReader = this.getArchiveEntryReader();
        final LazyList lazyList = new LazyList();
        int n = 0;
        while (archiveIterator.hasNext()) {
            Object object = archiveIterator.next();
            FileFolder fileFolder = this.archiveFolder;
            String string = archiveEntryReader.getInnerPath(object);
            if (string != null) {
                Iterator<String> iterator = Util.splitPath(string).iterator();
                while (iterator.hasNext()) {
                    TreeNode treeNode;
                    String string2 = iterator.next();
                    if (iterator.hasNext() || archiveEntryReader.isDirectory(object)) {
                        treeNode = (FileFolder)fileFolder.getSubFolder(string2);
                        if (treeNode == null) {
                            treeNode = new FileFolder(fileFolder, string2, null);
                        }
                        fileFolder = treeNode;
                        continue;
                    }
                    long l = archiveEntryReader.getLastModified(object);
                    treeNode = indexingConfig.isArchive(string2) ? new FileFolder(fileFolder, string2, (Long)l) : new FileDocument(fileFolder, string2, l);
                    Path path3 = treeNode.getPath();
                    long l2 = archiveEntryReader.getUnpackedSize(object);
                    boolean bl2 = archiveEntryReader.isEncrypted(object);
                    if (bl2) {
                        lazyList.add(treeNode);
                    }
                    EntryData entryData = new EntryData(n, l2, string, bl2);
                    this.entryDataMap.put(path3, entryData);
                }
            }
            ++n;
        }
        archiveIterator.finished();
        if (bl) {
            SolidArchiveTree.applyHtmlPairing(this.archiveFolder);
        }
        SolidArchiveTree.applyFilter(this.archiveFolder, new Predicate<FileDocument>(){

            public boolean apply(FileDocument fileDocument) {
                String string = fileDocument.getName();
                Path path = fileDocument.getPath();
                block4: for (PatternAction patternAction : indexingConfig.getPatternActions()) {
                    switch (patternAction.getAction()) {
                        case EXCLUDE: {
                            if (!patternAction.matches(string, path, true)) continue block4;
                            SolidArchiveTree.this.entryDataMap.removeKey(path);
                            lazyList.remove(fileDocument);
                            return true;
                        }
                        case DETECT_MIME: {
                            if (!patternAction.matches(string, path, true)) continue block4;
                            return false;
                        }
                    }
                    throw new IllegalStateException();
                }
                if (!ParseService.canParseByName(indexingConfig, string)) {
                    SolidArchiveTree.this.entryDataMap.removeKey(path);
                    lazyList.remove(fileDocument);
                    return true;
                }
                return false;
            }
        }, new Predicate<FileFolder>(){

            public boolean apply(FileFolder fileFolder) {
                String string = fileFolder.getName();
                Path path = fileFolder.getPath();
                boolean bl = fileFolder.isArchive();
                for (PatternAction patternAction : indexingConfig.getPatternActions()) {
                    if (patternAction.getAction() != PatternAction.MatchAction.EXCLUDE || !patternAction.matches(string, path, bl)) continue;
                    if (bl) {
                        SolidArchiveTree.this.entryDataMap.removeKey(path);
                        lazyList.remove(fileFolder);
                    }
                    return true;
                }
                return false;
            }
        });
        for (Object object : lazyList) {
            failReporter.fail(IndexingError.ErrorType.ARCHIVE_ENTRY_ENCRYPTED, (TreeNode)object, null);
        }
    }

    protected abstract ArchiveIterator<E> getArchiveIterator(File var1, String var2) throws IOException, ArchiveEncryptedException;

    protected abstract ArchiveEntryReader<E> getArchiveEntryReader();

    @Override
    public abstract void close() throws IOException;

    private static void applyHtmlPairing(FileFolder fileFolder) {
        for (FileFolder fileFolder2 : fileFolder.getSubFolders()) {
            String string = HtmlUtil.getHtmlDirBasename(fileFolder2.getName());
            if (string == null) {
                SolidArchiveTree.applyHtmlPairing(fileFolder2);
                continue;
            }
            boolean bl = false;
            for (String string2 : ProgramConf.StrList.HtmlExtensions.get()) {
                String string3 = string + "." + string2;
                FileDocument fileDocument = (FileDocument)fileFolder.getDocument(string3);
                if (fileDocument == null) continue;
                fileDocument.setHtmlFolder(fileFolder2);
                fileFolder.removeSubFolder(fileFolder2);
                Folder.evtFolderRemoved.fire(new Folder.FolderEvent(fileFolder, fileFolder2));
                bl = true;
                break;
            }
            if (bl) continue;
            SolidArchiveTree.applyHtmlPairing(fileFolder2);
        }
    }

    private static void applyFilter(FileFolder fileFolder, Predicate<FileDocument> predicate, Predicate<FileFolder> predicate2) {
        fileFolder.removeDocuments(predicate);
        fileFolder.removeSubFolders(predicate2);
        for (TreeNode treeNode : fileFolder.getDocuments()) {
            FileFolder fileFolder2 = treeNode.getHtmlFolder();
            if (fileFolder2 == null) continue;
            SolidArchiveTree.applyFilter(fileFolder2, predicate, predicate2);
        }
        for (TreeNode treeNode : fileFolder.getSubFolders()) {
            SolidArchiveTree.applyFilter((FileFolder)treeNode, predicate, predicate2);
        }
    }

    public final void unpack(TreeNode treeNode) throws IOException, DiskSpaceException {
        this.unpack(Collections.singleton(treeNode), null);
    }

    public final void unpack(Iterable<? extends TreeNode> iterable, final File file) throws IOException, DiskSpaceException {
        Object object;
        final long[] lArray = new long[]{0L};
        final HashMap hashMap = Maps.newHashMap();
        for (TreeNode object22 : iterable) {
            EntryData entryData = this.entryDataMap.getValue(object22.getPath());
            hashMap.put(entryData.index, object22);
            lArray[0] = lArray[0] + entryData.size;
            if (!SolidArchiveTree.hasHtmlFolder(object22)) continue;
            new FileFolder.FileFolderVisitor<Exception>((FileDocument)object22){

                @Override
                protected void visitDocument(FileFolder fileFolder, FileDocument fileDocument) {
                    Path path = fileDocument.getPath();
                    EntryData entryData = SolidArchiveTree.this.entryDataMap.getValue(path);
                    hashMap.put(entryData.index, fileDocument);
                    lArray[0] = lArray[0] + entryData.size;
                }
            }.runSilently();
        }
        if (hashMap.isEmpty()) {
            return;
        }
        this.config.checkDiskSpaceInTempDir(lArray[0]);
        if (file == null) {
            object = this.defaultTempFileFactory;
        } else {
            assert (file.isDirectory());
            object = new TempFileFactory(){
                private String tempDirPath;
                {
                    this.tempDirPath = Util.getAbsPath(file);
                }

                @Override
                public File createTempFile(TreeNode treeNode) throws IndexingException {
                    EntryData entryData = SolidArchiveTree.this.entryDataMap.getValue(treeNode.getPath());
                    String string = Util.joinPath(this.tempDirPath, entryData.innerPath, new String[0]);
                    File file2 = new File(string);
                    try {
                        Files.createParentDirs((File)file2);
                    }
                    catch (IOException iOException) {
                        throw new IndexingException(iOException);
                    }
                    return file2;
                }
            };
        }
        final Map<Integer, File> map = this.doUnpack(hashMap, (TempFileFactory)object);
        for (TreeNode treeNode : iterable) {
            EntryData entryData = this.entryDataMap.getValue(treeNode.getPath());
            entryData.file = map.get(entryData.index);
            if (!SolidArchiveTree.hasHtmlFolder(treeNode)) continue;
            new FileFolder.FileFolderVisitor<Exception>((FileDocument)treeNode){

                @Override
                protected void visitDocument(FileFolder fileFolder, FileDocument fileDocument) {
                    Path path = fileDocument.getPath();
                    EntryData entryData = SolidArchiveTree.this.entryDataMap.getValue(path);
                    entryData.file = (File)map.get(entryData.index);
                }
            }.runSilently();
        }
    }

    private static boolean hasHtmlFolder(TreeNode treeNode) {
        if (!(treeNode instanceof FileDocument)) {
            return false;
        }
        return ((FileDocument)treeNode).getHtmlFolder() != null;
    }

    protected abstract Map<Integer, File> doUnpack(Map<Integer, TreeNode> var1, TempFileFactory var2) throws IOException;

    public final File getArchiveFile() {
        return this.archiveFile;
    }

    public final FileFolder getArchiveFolder() {
        return this.archiveFolder;
    }

    public final File getFile(TreeNode treeNode) {
        EntryData entryData = this.entryDataMap.getValue(treeNode.getPath());
        if (entryData == null) {
            return null;
        }
        return entryData.file;
    }

    public final boolean isEncrypted(TreeNode treeNode) {
        EntryData entryData = this.entryDataMap.getValue(treeNode.getPath());
        if (entryData == null) {
            return false;
        }
        return entryData.isEncrypted;
    }

    public final void deleteUnpackedFiles() {
        for (EntryData entryData : this.entryDataMap.values()) {
            if (entryData.file == null) continue;
            entryData.file.delete();
        }
    }

    public final String getArchiveEntryPath(TreeNode treeNode) {
        EntryData entryData = this.entryDataMap.getValue(treeNode.getPath());
        if (entryData == null) {
            return null;
        }
        return entryData.innerPath;
    }

    public static interface FailReporter {
        public void fail(IndexingError.ErrorType var1, TreeNode var2, Throwable var3);
    }

    protected class TempFileFactory {
        protected TempFileFactory() {
        }

        public File createTempFile(TreeNode treeNode) throws IndexingException {
            return SolidArchiveTree.this.config.createDerivedTempFile(treeNode.getName());
        }
    }

    private static final class NullFailReporter
    implements FailReporter {
        private NullFailReporter() {
        }

        @Override
        public void fail(IndexingError.ErrorType errorType, TreeNode treeNode, Throwable throwable) {
        }
    }

    protected static interface ArchiveIterator<E> {
        public boolean hasNext();

        public E next();

        public void finished();
    }

    protected static interface ArchiveEntryReader<E> {
        public String getInnerPath(E var1);

        public boolean isDirectory(E var1);

        public long getLastModified(E var1);

        public long getUnpackedSize(E var1);

        public boolean isEncrypted(E var1);
    }

    private static final class EntryData {
        private int index;
        private long size;
        private final String innerPath;
        private final boolean isEncrypted;
        private File file;

        public EntryData(int n, long l, String string, boolean bl) {
            this.index = n;
            this.size = l;
            this.innerPath = string;
            this.isEncrypted = bl;
        }
    }
}

