/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.model.index.file;

import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.File;
import java.util.ArrayList;
import net.sourceforge.docfetcher.TestFiles;
import net.sourceforge.docfetcher.model.TreeNode;
import net.sourceforge.docfetcher.model.index.IndexingConfig;
import net.sourceforge.docfetcher.model.index.file.FileDocument;
import net.sourceforge.docfetcher.model.index.file.FileFolder;
import net.sourceforge.docfetcher.model.index.file.RarTree;
import net.sourceforge.docfetcher.model.index.file.SevenZipTree;
import net.sourceforge.docfetcher.model.index.file.SolidArchiveTree;
import net.sourceforge.docfetcher.util.AppUtil;
import net.sourceforge.docfetcher.util.Util;
import org.junit.Assert;
import org.junit.Test;

public final class SolidArchiveTreeTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPreserveDirStructure() throws Exception {
        IndexingConfig indexingConfig = new IndexingConfig();
        ArrayList arrayList = Lists.newArrayList();
        try {
            File file = TestFiles.multiple_dirs_7z.get();
            arrayList.add(new SevenZipTree(file, indexingConfig, null, null));
            Object object = TestFiles.multiple_dirs_rar.get();
            arrayList.add(new RarTree((File)object, indexingConfig, null, null));
            for (SolidArchiveTree solidArchiveTree : arrayList) {
                final ArrayList arrayList2 = new ArrayList(1);
                new FileFolder.FileFolderVisitor<Exception>(this, solidArchiveTree.getArchiveFolder()){

                    @Override
                    protected void visitDocument(FileFolder fileFolder, FileDocument fileDocument) {
                        arrayList2.add(fileDocument);
                    }
                }.runSilently();
                Assert.assertEquals((long)1L, (long)arrayList2.size());
                File file2 = Util.createTempDir();
                solidArchiveTree.unpack(arrayList2, file2);
                File file3 = solidArchiveTree.getFile((TreeNode)arrayList2.get(0));
                Assert.assertTrue((boolean)file3.isFile());
                String string = Util.getAbsPath(file3);
                String string2 = Util.getAbsPath(file2);
                String string3 = "test1/test2/test3/test.txt";
                Assert.assertTrue((boolean)string.equals(Util.joinPath(string2, string3, new String[0])));
                Util.deleteRecursively(file2);
                Assert.assertFalse((boolean)file3.isFile());
            }
        }
        finally {
            for (Object object : arrayList) {
                Closeables.closeQuietly((Closeable)object);
            }
        }
    }

    @Test
    public void test7zEntryWithoutName() throws Exception {
        File file = TestFiles.entry_without_name_7z.get();
        SevenZipTree sevenZipTree = null;
        try {
            sevenZipTree = new SevenZipTree(file, new IndexingConfig(), null, null);
        }
        catch (Throwable throwable) {
            Closeables.closeQuietly(sevenZipTree);
            throw throwable;
        }
        Closeables.closeQuietly((Closeable)sevenZipTree);
    }

    static {
        AppUtil.Const.autoInit();
    }
}

