/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.model.index.file;

import SevenZip.Archive.SevenZip.Handler;
import SevenZip.Archive.SevenZipEntry;
import SevenZip.IInStream;
import com.google.common.io.Closeables;
import de.innosystec.unrar.Archive;
import de.innosystec.unrar.rarfile.FileHeader;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.docfetcher.TestFiles;
import net.sourceforge.docfetcher.model.index.file.SevenZipInputStream;
import net.sourceforge.docfetcher.util.Util;
import org.junit.Assert;
import org.junit.Test;

public class TestUnpackFromZip {
    @Test
    public void testUnpackFromZip() {
        Checker[] checkerArray;
        for (Checker checker : checkerArray = new Checker[]{new RarChecker(), new SevenZipChecker()}) {
            Assert.assertTrue((boolean)checker.entry.exists());
            try {
                checker.readUncompressed();
                Assert.assertTrue((boolean)true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                checker.readCompressed();
                Assert.assertTrue((boolean)false);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static abstract class Checker {
        private TFile entry;

        public Checker(TestFiles testFiles) {
            this.entry = new TFile(testFiles.getPath());
        }

        public final void readUncompressed() throws Exception {
            TFile tFile = new TFile(Util.createTempFile("test", ""));
            this.entry.cp((File)tFile);
            this.read(tFile);
        }

        public final void readCompressed() throws Exception {
            this.read(this.entry);
        }

        protected abstract void read(TFile var1) throws Exception;
    }

    private static class RarChecker
    extends Checker {
        public RarChecker() {
            super(TestFiles.truezip_compat_rar);
        }

        @Override
        public void read(TFile tFile) throws Exception {
            Logger logger = Logger.getLogger(Archive.class.getName());
            logger.setLevel(Level.OFF);
            Archive archive = new Archive((File)tFile);
            FileHeader fileHeader = archive.nextFileHeader();
            TFileOutputStream tFileOutputStream = new TFileOutputStream(Util.createTempFile(tFile.getName(), ""));
            archive.extractFile(fileHeader, (OutputStream)tFileOutputStream);
            Closeables.closeQuietly((Closeable)tFileOutputStream);
            Closeables.closeQuietly((Closeable)archive);
        }
    }

    private static class SevenZipChecker
    extends Checker {
        public SevenZipChecker() {
            super(TestFiles.truezip_compat_7z);
        }

        @Override
        protected void read(TFile tFile) throws Exception {
            Handler handler = new Handler();
            SevenZipInputStream sevenZipInputStream = new SevenZipInputStream((File)tFile);
            if (handler.Open((IInStream)sevenZipInputStream) != 0) {
                throw new IOException();
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < handler.size(); ++i) {
                SevenZipEntry sevenZipEntry = handler.getEntry(i);
                stringBuilder.append(sevenZipEntry.getName()).append("\n");
            }
            handler.close();
        }
    }
}

