/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.model.index.outlook;

import com.google.common.collect.Maps;
import com.google.common.io.Closeables;
import com.pff.PSTException;
import com.pff.PSTFile;
import com.pff.PSTFolder;
import com.pff.PSTMessage;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import net.sourceforge.docfetcher.model.Cancelable;
import net.sourceforge.docfetcher.model.DocumentType;
import net.sourceforge.docfetcher.model.Path;
import net.sourceforge.docfetcher.model.TreeIndex;
import net.sourceforge.docfetcher.model.UtilModel;
import net.sourceforge.docfetcher.model.index.IndexWriterAdapter;
import net.sourceforge.docfetcher.model.index.IndexingError;
import net.sourceforge.docfetcher.model.index.IndexingException;
import net.sourceforge.docfetcher.model.index.IndexingReporter;
import net.sourceforge.docfetcher.model.index.outlook.MailDocument;
import net.sourceforge.docfetcher.model.index.outlook.MailFolder;
import net.sourceforge.docfetcher.model.index.outlook.OutlookContext;
import net.sourceforge.docfetcher.model.index.outlook.TreeRootSimplifier;
import net.sourceforge.docfetcher.util.Util;

public final class OutlookIndex
extends TreeIndex<MailDocument, MailFolder> {
    private static final long serialVersionUID = 1L;
    private MailFolder simplifiedRootFolder;

    public OutlookIndex(File file, File file2) {
        super(file, file2);
    }

    @Override
    protected String getIndexDirName(File file) {
        return Util.splitFilename(file)[0];
    }

    @Override
    protected MailFolder createRootFolder(Path path) {
        return new MailFolder(path);
    }

    @Override
    public boolean isEmailIndex() {
        return true;
    }

    @Override
    public DocumentType getDocumentType() {
        return DocumentType.OUTLOOK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TreeIndex.IndexingResult doUpdate(IndexingReporter indexingReporter, Cancelable cancelable) {
        block13: {
            TreeIndex.IndexingResult indexingResult;
            IndexWriterAdapter indexWriterAdapter;
            block12: {
                indexingReporter.setStartTime(System.currentTimeMillis());
                MailFolder mailFolder = (MailFolder)this.getRootFolder();
                mailFolder.setError(null);
                indexWriterAdapter = null;
                PSTFile pSTFile = null;
                try {
                    File file = this.getCanonicalRootFile();
                    long l = file.lastModified();
                    if (UtilModel.isUnmodifiedArchive(mailFolder, l)) {
                        TreeIndex.IndexingResult indexingResult2 = TreeIndex.IndexingResult.SUCCESS_UNCHANGED;
                        return indexingResult2;
                    }
                    mailFolder.setLastModified(l);
                    indexWriterAdapter = new IndexWriterAdapter(this.getLuceneDir());
                    OutlookContext outlookContext = new OutlookContext(this.getConfig(), indexWriterAdapter, indexingReporter, cancelable);
                    pSTFile = new PSTFile(file.getPath());
                    OutlookIndex.visitFolder(outlookContext, mailFolder, pSTFile.getRootFolder());
                    this.simplifiedRootFolder = new TreeRootSimplifier<MailFolder>(this){

                        @Override
                        protected boolean hasContent(MailFolder mailFolder) {
                            return mailFolder.getDocumentCount() > 0;
                        }

                        @Override
                        protected boolean hasDeepContent(MailFolder mailFolder) {
                            return mailFolder.hasDeepContent();
                        }

                        @Override
                        protected Collection<MailFolder> getChildren(MailFolder mailFolder) {
                            return mailFolder.getSubFolders();
                        }
                    }.getSimplifiedRoot((MailFolder)this.getRootFolder());
                    indexingResult = TreeIndex.IndexingResult.SUCCESS_CHANGED;
                    if (pSTFile == null) break block12;
                }
                catch (PSTException pSTException) {
                    this.report(indexingReporter, (Exception)((Object)pSTException));
                    break block13;
                }
                catch (IOException iOException) {
                    this.report(indexingReporter, iOException);
                    break block13;
                }
                catch (IndexingException indexingException) {
                    this.report(indexingReporter, indexingException.getIOException());
                    break block13;
                }
                finally {
                    if (pSTFile != null) {
                        Closeables.closeQuietly((Closeable)pSTFile.getFileHandle());
                    }
                    Closeables.closeQuietly(indexWriterAdapter);
                    indexingReporter.setEndTime(System.currentTimeMillis());
                }
                Closeables.closeQuietly((Closeable)pSTFile.getFileHandle());
            }
            Closeables.closeQuietly((Closeable)indexWriterAdapter);
            indexingReporter.setEndTime(System.currentTimeMillis());
            return indexingResult;
        }
        return TreeIndex.IndexingResult.FAILURE;
    }

    private void report(IndexingReporter indexingReporter, Exception exception) {
        MailFolder mailFolder = (MailFolder)this.getRootFolder();
        IndexingError indexingError = new IndexingError(IndexingError.ErrorType.IO_EXCEPTION, mailFolder, exception);
        mailFolder.setError(indexingError);
        indexingReporter.fail(indexingError);
    }

    public MailFolder getSimplifiedRootFolder() {
        if (this.simplifiedRootFolder == null) {
            return (MailFolder)this.getRootFolder();
        }
        return this.simplifiedRootFolder;
    }

    private static void visitFolder(OutlookContext outlookContext, MailFolder mailFolder, PSTFolder pSTFolder) throws IndexingException, PSTException {
        Serializable serializable;
        String string;
        mailFolder.setHasDeepContent(false);
        HashMap hashMap = Maps.newHashMap(mailFolder.getDocumentMap());
        HashMap hashMap2 = Maps.newHashMap(mailFolder.getSubFolderMap());
        LinkedList<PSTFolder> linkedList = new LinkedList<PSTFolder>();
        if (pSTFolder.getContentCount() > 0) {
            try {
                Object object;
                try {
                    object = pSTFolder.getNextChild();
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    Util.printErr(indexOutOfBoundsException.getMessage());
                    object = null;
                }
                while (object != null && !outlookContext.isStopped()) {
                    if (object instanceof PSTFolder) {
                        linkedList.add((PSTFolder)object);
                    } else if (object instanceof PSTMessage) {
                        PSTMessage indexOutOfBoundsException = (PSTMessage)object;
                        string = String.valueOf(indexOutOfBoundsException.getDescriptorNodeId());
                        serializable = indexOutOfBoundsException.getLastModificationTime();
                        long l = serializable == null ? 0L : serializable.getTime();
                        MailDocument mailDocument = (MailDocument)hashMap.remove(string);
                        if (mailDocument == null) {
                            String string2 = indexOutOfBoundsException.getSubject();
                            mailDocument = new MailDocument(mailFolder, string, string2, l);
                            outlookContext.index(mailDocument, indexOutOfBoundsException, true);
                        } else if (mailDocument.isModified(l)) {
                            mailDocument.setLastModified(l);
                            outlookContext.index(mailDocument, indexOutOfBoundsException, false);
                        }
                    }
                    try {
                        object = pSTFolder.getNextChild();
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        Util.printErr(indexOutOfBoundsException.getMessage());
                        object = null;
                    }
                }
            }
            catch (IOException iOException) {
                throw new IndexingException(iOException);
            }
            mailFolder.setHasDeepContent(true);
        }
        if (pSTFolder.hasSubfolders() || !linkedList.isEmpty()) {
            try {
                linkedList.addAll(pSTFolder.getSubFolders());
                for (PSTFolder pSTFolder2 : linkedList) {
                    if (!outlookContext.isStopped()) {
                        string = pSTFolder2.getDisplayName();
                        serializable = (MailFolder)hashMap2.remove(string);
                        if (serializable == null) {
                            serializable = new MailFolder(mailFolder, string);
                        }
                        OutlookIndex.visitFolder(outlookContext, (MailFolder)serializable, pSTFolder2);
                        if (!((MailFolder)serializable).hasDeepContent()) continue;
                        mailFolder.setHasDeepContent(true);
                        continue;
                    }
                    break;
                }
            }
            catch (IOException iOException) {
                throw new IndexingException(iOException);
            }
        }
        if (outlookContext.isStopped()) {
            return;
        }
        for (MailDocument mailDocument : hashMap.values()) {
            outlookContext.deleteFromIndex(mailDocument.getUniqueId());
            mailFolder.removeDocument(mailDocument);
        }
        for (MailFolder mailFolder2 : hashMap2.values()) {
            mailFolder.removeSubFolder(mailFolder2);
        }
    }
}

