/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.model.parse;

import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.zip.GZIPInputStream;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.Source;
import net.sourceforge.docfetcher.enums.Msg;
import net.sourceforge.docfetcher.model.parse.MediaType;
import net.sourceforge.docfetcher.model.parse.ParseContext;
import net.sourceforge.docfetcher.model.parse.ParseException;
import net.sourceforge.docfetcher.model.parse.ParseResult;
import net.sourceforge.docfetcher.model.parse.StreamParser;
import net.sourceforge.docfetcher.util.Util;

final class AbiWordParser
extends StreamParser {
    private static final Collection<String> extensions = Arrays.asList("abw", "abw.gz", "zabw");
    private static final Collection<String> types = Arrays.asList(MediaType.text("xml"), MediaType.application("x-gzip"));

    AbiWordParser() {
    }

    @Override
    protected ParseResult parse(InputStream inputStream, ParseContext parseContext) throws ParseException {
        Source source = AbiWordParser.getSource(inputStream, parseContext.getFilename());
        String string = this.getMetaData(source, "dc.creator");
        String string2 = this.getMetaData(source, "dc.title");
        String string3 = source.getTextExtractor().toString();
        return new ParseResult(string3).setTitle(string2).addAuthor(string);
    }

    private String getMetaData(Source source, String string) {
        Element element = source.getNextElement(0, "key", string, false);
        if (element == null) {
            return null;
        }
        return element.getTextExtractor().toString();
    }

    @Override
    protected String renderText(InputStream inputStream, String string) throws ParseException {
        Object object;
        int n;
        Source source = AbiWordParser.getSource(inputStream, string);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Element element = source.getNextElement(0, "metadata");
        int n2 = n = element == null ? 0 : element.getEnd();
        while (n < source.length() && (object = source.getNextElement(n)) != null) {
            arrayList.add(object);
            n = object.getEnd();
        }
        object = new StringBuilder();
        for (Element element2 : arrayList) {
            ((StringBuilder)object).append(element2.getRenderer().toString());
        }
        return ((StringBuilder)object).toString();
    }

    private static Source getSource(InputStream inputStream, String string) throws ParseException {
        try {
            String string2 = Util.getExtension(string);
            if (string2.equals("zabw") || string2.equals("abw.gz")) {
                inputStream = new GZIPInputStream(inputStream);
            }
            Source source = new Source(inputStream);
            source.setLogger(null);
            source.fullSequentialParse();
            Source source2 = source;
            return source2;
        }
        catch (IOException iOException) {
            throw new ParseException(iOException);
        }
        finally {
            Closeables.closeQuietly((Closeable)inputStream);
        }
    }

    @Override
    protected Collection<String> getExtensions() {
        return extensions;
    }

    @Override
    protected Collection<String> getTypes() {
        return types;
    }

    @Override
    public String getTypeLabel() {
        return Msg.filetype_abi.get();
    }
}

