/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.model.parse;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.htmlparser.jericho.Source;
import net.sourceforge.docfetcher.enums.Msg;
import net.sourceforge.docfetcher.model.parse.ParseContext;
import net.sourceforge.docfetcher.model.parse.ParseException;
import net.sourceforge.docfetcher.model.parse.ParseResult;
import net.sourceforge.docfetcher.model.parse.StreamParser;
import org.apache.tika.parser.chm.accessor.ChmDirectoryListingSet;
import org.apache.tika.parser.chm.accessor.DirectoryListingEntry;
import org.apache.tika.parser.chm.core.ChmExtractor;

public final class ChmParser
extends StreamParser {
    private static final Collection<String> extensions = Collections.singleton("chm");

    @Override
    protected ParseResult parse(InputStream inputStream, ParseContext parseContext) throws ParseException {
        ChmExtractor chmExtractor = null;
        try {
            chmExtractor = new ChmExtractor(inputStream);
        }
        catch (Exception exception) {
            throw new ParseException(exception);
        }
        ArrayList<DirectoryListingEntry> arrayList = new ArrayList<DirectoryListingEntry>();
        ChmDirectoryListingSet chmDirectoryListingSet = chmExtractor.getChmDirList();
        if (chmDirectoryListingSet == null) {
            throw new ParseException("Failed to list entries.");
        }
        for (DirectoryListingEntry directoryListingEntry : chmDirectoryListingSet.getDirectoryListingEntryList()) {
            String string = directoryListingEntry.getName().toLowerCase();
            if (!string.endsWith(".html") && !string.endsWith(".htm")) continue;
            arrayList.add(directoryListingEntry);
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = arrayList.size();
        int n2 = 1;
        for (DirectoryListingEntry directoryListingEntry : arrayList) {
            parseContext.getReporter().subInfo(n2, n);
            try {
                byte[] byArray = chmExtractor.extractChmEntry(directoryListingEntry);
                String string = ChmParser.parsePage(byArray, false);
                if (string != null && !string.isEmpty()) {
                    if (n2 > 1) {
                        stringBuilder.append("\n\n");
                    }
                    stringBuilder.append(string);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
        return new ParseResult(stringBuilder.toString());
    }

    @Override
    protected String renderText(InputStream inputStream, String string) throws ParseException {
        ChmExtractor chmExtractor = null;
        try {
            chmExtractor = new ChmExtractor(inputStream);
        }
        catch (Exception exception) {
            throw new ParseException(exception);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (DirectoryListingEntry directoryListingEntry : chmExtractor.getChmDirList().getDirectoryListingEntryList()) {
            String string2 = directoryListingEntry.getName().toLowerCase();
            if (!string2.endsWith(".html") && !string2.endsWith(".htm")) continue;
            try {
                byte[] byArray = chmExtractor.extractChmEntry(directoryListingEntry);
                String string3 = ChmParser.parsePage(byArray, true);
                if (string3 == null || string3.isEmpty()) continue;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("\n\n");
                }
                stringBuilder.append(string3);
            }
            catch (Exception exception) {}
        }
        return stringBuilder.toString();
    }

    static String parsePage(byte[] byArray, boolean bl) throws IOException {
        try {
            Source source = new Source((InputStream)new ByteArrayInputStream(byArray));
            source.setLogger(null);
            if (bl) {
                return source.getRenderer().setIncludeHyperlinkURLs(false).toString();
            }
            return source.getTextExtractor().toString();
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    @Override
    protected Collection<String> getExtensions() {
        return extensions;
    }

    @Override
    protected Collection<String> getTypes() {
        return Collections.emptyList();
    }

    @Override
    public String getTypeLabel() {
        return Msg.filetype_chm.get();
    }
}

