/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.model.parse;

import com.drew.imaging.jpeg.JpegMetadataReader;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.Tag;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import net.sourceforge.docfetcher.enums.Msg;
import net.sourceforge.docfetcher.model.parse.ParseContext;
import net.sourceforge.docfetcher.model.parse.ParseException;
import net.sourceforge.docfetcher.model.parse.ParseResult;
import net.sourceforge.docfetcher.model.parse.StreamParser;

final class ExifParser
extends StreamParser {
    private static final Collection<String> extensions = Arrays.asList("jpg", "jpeg");
    private static final Collection<String> types = Arrays.asList("image/jpg");

    ExifParser() {
    }

    @Override
    protected ParseResult parse(InputStream inputStream, ParseContext parseContext) throws ParseException {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            Metadata metadata = JpegMetadataReader.readMetadata((InputStream)inputStream);
            for (Directory directory : metadata.getDirectories()) {
                stringBuilder.append(directory.getName()).append("\n");
                for (Tag tag : directory.getTags()) {
                    stringBuilder.append(tag.getDescription()).append("\n");
                }
            }
        }
        catch (Exception exception) {
            throw new ParseException(exception);
        }
        return new ParseResult(stringBuilder.toString());
    }

    @Override
    protected String renderText(InputStream inputStream, String string) throws ParseException {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            Metadata metadata = JpegMetadataReader.readMetadata((InputStream)inputStream);
            for (Directory directory : metadata.getDirectories()) {
                stringBuilder.append("Directory = " + directory.getName() + "\n");
                for (Tag tag : directory.getTags()) {
                    stringBuilder.append("  Tag " + tag.getTagName() + " = " + tag.getDescription() + "\n");
                }
            }
        }
        catch (Exception exception) {
            throw new ParseException(exception);
        }
        return stringBuilder.toString();
    }

    @Override
    protected Collection<String> getExtensions() {
        return extensions;
    }

    @Override
    protected Collection<String> getTypes() {
        return types;
    }

    @Override
    public String getTypeLabel() {
        return Msg.filetype_jpg.get();
    }
}

