/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.model.parse;

import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import net.sourceforge.docfetcher.enums.Msg;
import net.sourceforge.docfetcher.model.parse.ParseContext;
import net.sourceforge.docfetcher.model.parse.ParseException;
import net.sourceforge.docfetcher.model.parse.ParseResult;
import net.sourceforge.docfetcher.model.parse.ParseService;
import net.sourceforge.docfetcher.model.parse.StreamParser;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.mp3.Mp3Parser;
import org.apache.tika.sax.BodyContentHandler;

final class MP3Parser
extends StreamParser {
    private static final Collection<String> extensions = Arrays.asList("mp3");
    private static final Collection<String> types = Arrays.asList("audio/mpeg");

    MP3Parser() {
    }

    @Override
    protected ParseResult parse(InputStream inputStream, ParseContext parseContext) throws ParseException {
        try {
            return new ParseResult(MP3Parser.extract(inputStream));
        }
        catch (Exception exception) {
            throw new ParseException(exception);
        }
    }

    @Override
    protected String renderText(InputStream inputStream, String string) throws ParseException {
        try {
            return MP3Parser.extract(inputStream);
        }
        catch (Exception exception) {
            throw new ParseException(exception);
        }
    }

    @Override
    protected Collection<String> getExtensions() {
        return extensions;
    }

    @Override
    protected Collection<String> getTypes() {
        return types;
    }

    @Override
    public String getTypeLabel() {
        return Msg.filetype_mp3.get();
    }

    private static String extract(InputStream inputStream) throws Exception {
        BodyContentHandler bodyContentHandler = new BodyContentHandler(-1);
        Metadata metadata = new Metadata();
        new Mp3Parser().parse(inputStream, bodyContentHandler, metadata, ParseService.tikaContext());
        return bodyContentHandler.toString();
    }
}

