/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.model.parse;

import com.google.common.io.Closeables;
import java.io.CharConversionException;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.zip.ZipError;
import net.sourceforge.docfetcher.enums.Msg;
import net.sourceforge.docfetcher.model.parse.FileParser;
import net.sourceforge.docfetcher.model.parse.MediaType;
import net.sourceforge.docfetcher.model.parse.ParseContext;
import net.sourceforge.docfetcher.model.parse.ParseException;
import net.sourceforge.docfetcher.model.parse.ParseResult;
import net.sourceforge.docfetcher.model.parse.ParseService;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.odf.OpenDocumentParser;
import org.apache.tika.sax.BodyContentHandler;
import org.xml.sax.SAXException;

abstract class OpenOfficeParser
extends FileParser {
    private static final Collection<String> types = MediaType.Col.application("zip");
    private final String typeLabel;
    private final Collection<String> extensions;

    private OpenOfficeParser(String string, String ... stringArray) {
        this.typeLabel = string;
        this.extensions = Arrays.asList(stringArray);
    }

    @Override
    protected final Collection<String> getExtensions() {
        return this.extensions;
    }

    @Override
    public final String getTypeLabel() {
        return this.typeLabel;
    }

    @Override
    protected final Collection<String> getTypes() {
        return types;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected final ParseResult parse(File file, ParseContext parseContext) throws ParseException {
        ParseResult parseResult;
        OpenDocumentParser openDocumentParser;
        try {
            openDocumentParser = new OpenDocumentParser();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throw new ParseException(noClassDefFoundError);
        }
        BodyContentHandler bodyContentHandler = new BodyContentHandler(-1);
        Metadata metadata = new Metadata();
        TikaInputStream tikaInputStream = null;
        try {
            tikaInputStream = TikaInputStream.get(Paths.get(file.getPath(), new String[0]));
            openDocumentParser.parse(tikaInputStream, bodyContentHandler, metadata, ParseService.tikaContext());
            ParseResult parseResult2 = new ParseResult(bodyContentHandler.toString()).setTitle(metadata.get(TikaCoreProperties.TITLE)).addAuthor(metadata.get(TikaCoreProperties.CREATOR)).addMiscMetadata(metadata.get(TikaCoreProperties.DESCRIPTION)).addMiscMetadata(metadata.get(TikaCoreProperties.TRANSITION_SUBJECT_TO_OO_SUBJECT)).addMiscMetadata(metadata.get(TikaCoreProperties.KEYWORDS));
            for (String string : metadata.names()) {
                if (!string.startsWith("custom:")) continue;
                parseResult2.addMiscMetadata(metadata.get(string));
            }
            parseResult = parseResult2;
        }
        catch (ZipError zipError) {
            try {
                String string = "The file appears to be corrupted or invalid. Try opening it in LibreOffice to verify if it's a valid document.";
                throw new ParseException(string, zipError);
                catch (CharConversionException charConversionException) {
                    if (OpenOfficeParser.matchesPasswordError(charConversionException)) {
                        throw new ParseException(Msg.doc_pw_protected.get());
                    }
                    throw new ParseException(charConversionException);
                }
                catch (IOException | TikaException | SAXException exception) {
                    throw new ParseException(exception);
                }
                catch (RuntimeException runtimeException) {
                    throw new ParseException(runtimeException);
                }
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(tikaInputStream);
                throw throwable;
            }
        }
        Closeables.closeQuietly((Closeable)tikaInputStream);
        return parseResult;
    }

    private static boolean matchesPasswordError(Exception exception) {
        return exception != null && exception instanceof CharConversionException;
    }

    public static final class OpenOfficeImpressParser
    extends OpenOfficeParser {
        public OpenOfficeImpressParser() {
            super(Msg.filetype_odp.get(), "odp", "otp");
        }
    }

    public static final class OpenOfficeDrawParser
    extends OpenOfficeParser {
        public OpenOfficeDrawParser() {
            super(Msg.filetype_odg.get(), "odg", "otg");
        }
    }

    public static final class OpenOfficeCalcParser
    extends OpenOfficeParser {
        public OpenOfficeCalcParser() {
            super(Msg.filetype_ods.get(), "ods", "ots");
        }
    }

    public static final class OpenOfficeWriterParser
    extends OpenOfficeParser {
        public OpenOfficeWriterParser() {
            super(Msg.filetype_odt.get(), "odt", "ott");
        }
    }
}

