/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.model.parse;

import java.io.File;
import java.io.FileInputStream;
import net.sourceforge.docfetcher.model.parse.ChmParser;
import net.sourceforge.docfetcher.model.parse.PageHandler;
import net.sourceforge.docfetcher.model.parse.ParseException;
import net.sourceforge.docfetcher.util.CheckedOutOfMemoryError;
import org.apache.tika.parser.chm.accessor.DirectoryListingEntry;
import org.apache.tika.parser.chm.core.ChmExtractor;

public final class PagingChmParser {
    private final File file;
    private final PageHandler handler;

    public PagingChmParser(File file, PageHandler pageHandler) {
        this.file = file;
        this.handler = pageHandler;
    }

    public void run() throws ParseException, CheckedOutOfMemoryError {
        ChmExtractor chmExtractor = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(this.file);
            chmExtractor = new ChmExtractor(fileInputStream);
        }
        catch (Exception exception) {
            throw new ParseException(exception);
        }
        for (DirectoryListingEntry directoryListingEntry : chmExtractor.getChmDirList().getDirectoryListingEntryList()) {
            String string = directoryListingEntry.getName().toLowerCase();
            if (!string.endsWith(".html") && !string.endsWith(".htm")) continue;
            try {
                byte[] byArray = chmExtractor.extractChmEntry(directoryListingEntry);
                String string2 = ChmParser.parsePage(byArray, true);
                if (string2 == null) {
                    string2 = "";
                }
                if (!this.handler.handlePage(string2)) continue;
                return;
            }
            catch (Exception exception) {
            }
        }
    }
}

