/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.model.parse;

import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import net.sourceforge.docfetcher.enums.Msg;
import net.sourceforge.docfetcher.enums.ProgramConf;
import net.sourceforge.docfetcher.model.parse.PageHandler;
import net.sourceforge.docfetcher.model.parse.ParseException;
import net.sourceforge.docfetcher.util.CheckedOutOfMemoryError;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.encryption.InvalidPasswordException;
import org.apache.pdfbox.text.PDFTextStripper;

public final class PagingPdfParser {
    private final File file;
    private final PageHandler handler;
    private final StringWriter writer = new StringWriter();

    public PagingPdfParser(File file, PageHandler pageHandler) {
        this.file = file;
        this.handler = pageHandler;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() throws ParseException, CheckedOutOfMemoryError {
        PDDocument pDDocument = null;
        try {
            try {
                pDDocument = PDDocument.load((File)this.file);
            }
            catch (InvalidPasswordException invalidPasswordException) {
                throw new ParseException(Msg.doc_pw_protected.get());
            }
            PagingStripper pagingStripper = new PagingStripper();
            if (ProgramConf.Bool.PdfPreviewVisualOrder.get()) {
                pagingStripper.setSortByPosition(true);
            }
            pagingStripper.writeText(pDDocument, this.writer);
        }
        catch (Exception exception) {
            try {
                if (!(exception instanceof ParseException)) throw new ParseException(exception);
                throw (ParseException)exception;
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    throw new ParseException(unsatisfiedLinkError);
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    Throwable throwable = noClassDefFoundError.getCause();
                    if (!(throwable instanceof ExceptionInInitializerError)) throw new ParseException(noClassDefFoundError);
                    Throwable throwable2 = throwable.getCause();
                    if (!(throwable2 instanceof OutOfMemoryError)) throw new ParseException(noClassDefFoundError);
                    throw new CheckedOutOfMemoryError((OutOfMemoryError)throwable2);
                }
                catch (ExceptionInInitializerError exceptionInInitializerError) {
                    Throwable throwable = exceptionInInitializerError.getCause();
                    if (!(throwable instanceof OutOfMemoryError)) throw new ParseException(exceptionInInitializerError);
                    throw new CheckedOutOfMemoryError((OutOfMemoryError)throwable);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    throw new CheckedOutOfMemoryError(outOfMemoryError);
                }
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(pDDocument);
                throw throwable;
            }
        }
        Closeables.closeQuietly((Closeable)pDDocument);
    }

    private class PagingStripper
    extends PDFTextStripper {
        protected void endPage(PDPage pDPage) throws IOException {
            StringBuffer stringBuffer = PagingPdfParser.this.writer.getBuffer();
            boolean bl = PagingPdfParser.this.handler.handlePage(stringBuffer.toString());
            stringBuffer.delete(0, stringBuffer.length());
            if (bl) {
                this.setEndPage(0);
            }
        }
    }
}

