/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.model.parse;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.docfetcher.TestFiles;
import net.sourceforge.docfetcher.enums.Msg;
import net.sourceforge.docfetcher.model.parse.PageHandler;
import net.sourceforge.docfetcher.model.parse.PagingPdfParser;
import net.sourceforge.docfetcher.model.parse.ParseException;
import net.sourceforge.docfetcher.util.CheckedOutOfMemoryError;
import net.sourceforge.docfetcher.util.Util;
import org.junit.Assert;
import org.junit.Test;

public final class PagingPdfParserTest {
    @Test
    public void testParse() throws ParseException, CheckedOutOfMemoryError {
        final ArrayList arrayList = new ArrayList(3);
        PageHandler pageHandler = new PageHandler(){

            @Override
            public boolean handlePage(String string) {
                arrayList.add(string);
                return false;
            }
        };
        new PagingPdfParser(TestFiles.multi_page_pdf.get(), pageHandler).run();
        Assert.assertEquals((long)3L, (long)arrayList.size());
        Assert.assertEquals((Object)("page 1" + Util.LS), arrayList.get(0));
        Assert.assertEquals((Object)("page 2" + Util.LS), arrayList.get(1));
        Assert.assertEquals((Object)("page 3" + Util.LS), arrayList.get(2));
    }

    @Test
    public void testParseAndStop() throws ParseException, CheckedOutOfMemoryError {
        final ArrayList arrayList = new ArrayList(2);
        PageHandler pageHandler = new PageHandler(){

            @Override
            public boolean handlePage(String string) {
                arrayList.add(string);
                return arrayList.size() >= 2;
            }
        };
        new PagingPdfParser(TestFiles.multi_page_pdf.get(), pageHandler).run();
        Assert.assertEquals((long)2L, (long)arrayList.size());
        Assert.assertEquals((Object)("page 1" + Util.LS), arrayList.get(0));
        Assert.assertEquals((Object)("page 2" + Util.LS), arrayList.get(1));
    }

    @Test
    public void testEncryptedPdf() throws Exception {
        Logger logger = Logger.getLogger("org.apache.pdfbox.pdfparser.PDFParser");
        logger.setLevel(Level.OFF);
        try {
            PageHandler pageHandler = new PageHandler(this){

                @Override
                public boolean handlePage(String string) {
                    return false;
                }
            };
            new PagingPdfParser(TestFiles.encrypted_pdf.get(), pageHandler).run();
            Assert.assertTrue((boolean)false);
        }
        catch (ParseException parseException) {
            Assert.assertTrue((boolean)parseException.getMessage().equals(Msg.doc_pw_protected.get()));
        }
    }
}

