/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.model.parse;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.docfetcher.util.Util;

public final class ParseResult {
    private CharSequence content;
    private String title;
    private List<String> authors;
    private List<String> miscMetadata;
    private String parserName;

    public ParseResult(CharSequence charSequence) {
        this.setContent(charSequence);
    }

    public CharSequence getContent() {
        return this.content;
    }

    public ParseResult setContent(CharSequence charSequence) {
        this.content = charSequence == null ? "" : charSequence;
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public ParseResult setTitle(String string) {
        this.title = string;
        return this;
    }

    public List<String> getAuthors() {
        return this.authors;
    }

    public ParseResult addAuthor(String string) {
        if (string == null) {
            return this;
        }
        if (this.authors == null) {
            this.authors = new ArrayList<String>(3);
        }
        this.authors.add(string);
        return this;
    }

    public List<String> getMiscMetadata() {
        return this.miscMetadata;
    }

    public ParseResult addMiscMetadata(String string) {
        if (string == null) {
            return this;
        }
        if (this.miscMetadata == null) {
            this.miscMetadata = new ArrayList<String>(5);
        }
        this.miscMetadata.add(string);
        return this;
    }

    public StringBuilder getMetadata() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.title != null) {
            stringBuilder.append(this.title).append(" ");
        }
        if (this.authors != null) {
            for (String string : this.authors) {
                stringBuilder.append(string).append(" ");
            }
        }
        if (this.miscMetadata != null) {
            for (String string : this.miscMetadata) {
                stringBuilder.append(string).append(" ");
            }
        }
        return stringBuilder;
    }

    public String getParserName() {
        return this.parserName;
    }

    public ParseResult setParserName(String string) {
        this.parserName = Util.checkNotNull(string);
        return this;
    }
}

