/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.model.parse;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import com.google.common.io.Closeables;
import com.google.common.primitives.Ints;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import eu.medsea.mimeutil.detector.MagicMimeMimeDetector;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.InvalidPathException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import net.sourceforge.docfetcher.enums.Msg;
import net.sourceforge.docfetcher.enums.ProgramConf;
import net.sourceforge.docfetcher.model.Cancelable;
import net.sourceforge.docfetcher.model.Path;
import net.sourceforge.docfetcher.model.index.IndexingConfig;
import net.sourceforge.docfetcher.model.index.IndexingException;
import net.sourceforge.docfetcher.model.index.IndexingReporter;
import net.sourceforge.docfetcher.model.index.PatternAction;
import net.sourceforge.docfetcher.model.parse.AbiWordParser;
import net.sourceforge.docfetcher.model.parse.ChmParser;
import net.sourceforge.docfetcher.model.parse.EpubParser;
import net.sourceforge.docfetcher.model.parse.ExifParser;
import net.sourceforge.docfetcher.model.parse.FLACParser;
import net.sourceforge.docfetcher.model.parse.FileParser;
import net.sourceforge.docfetcher.model.parse.HtmlParser;
import net.sourceforge.docfetcher.model.parse.MP3Parser;
import net.sourceforge.docfetcher.model.parse.MSExcelParser;
import net.sourceforge.docfetcher.model.parse.MSOffice2007Parser;
import net.sourceforge.docfetcher.model.parse.MSOfficeParser;
import net.sourceforge.docfetcher.model.parse.OpenOfficeParser;
import net.sourceforge.docfetcher.model.parse.ParseContext;
import net.sourceforge.docfetcher.model.parse.ParseException;
import net.sourceforge.docfetcher.model.parse.ParseResult;
import net.sourceforge.docfetcher.model.parse.Parser;
import net.sourceforge.docfetcher.model.parse.PdfParser;
import net.sourceforge.docfetcher.model.parse.RtfParser;
import net.sourceforge.docfetcher.model.parse.StreamParser;
import net.sourceforge.docfetcher.model.parse.SvgParser;
import net.sourceforge.docfetcher.model.parse.TextDetector;
import net.sourceforge.docfetcher.model.parse.TextParser;
import net.sourceforge.docfetcher.util.AppUtil;
import net.sourceforge.docfetcher.util.CheckedOutOfMemoryError;
import net.sourceforge.docfetcher.util.Util;
import net.sourceforge.docfetcher.util.gui.dialog.StackTraceWindow;
import org.eclipse.swt.widgets.Display;

public final class ParseService {
    private static final MagicMimeMimeDetector mimeDetector = new MagicMimeMimeDetector();
    private static final String FILENAME_PARSER = "FilenameParser";
    private static final TextParser textParser;
    private static final HtmlParser htmlParser;
    private static final List<Parser> parsers;

    private ParseService() {
    }

    public static List<Parser> getParsers() {
        return parsers;
    }

    @VisibleForTesting
    static List<Parser> getSortedMatchingParsers(IndexingConfig indexingConfig, File file, String string) throws IOException {
        class Match {
            final Parser parser;
            boolean mimeMatch = false;
            boolean extMatch = false;

            public Match(Parser parser) {
                this.parser = parser;
            }

            public int getMatchCount() {
                return (this.mimeMatch ? 1 : 0) + (this.extMatch ? 1 : 0);
            }
        }
        TreeSet treeSet = Sets.newTreeSet((Comparator)new Comparator<Match>(){

            @Override
            public int compare(Match match, Match match2) {
                int n = -1 * Ints.compare((int)match.getMatchCount(), (int)match2.getMatchCount());
                if (n != 0) {
                    return n;
                }
                if (match.mimeMatch && !match2.mimeMatch) {
                    return -1;
                }
                if (!match.mimeMatch && match2.mimeMatch) {
                    return 1;
                }
                String string = match.parser.getClass().getSimpleName();
                String string2 = match2.parser.getClass().getSimpleName();
                return string.compareTo(string2);
            }
        });
        List<String> list = ParseService.getPossibleMimeTypes(file);
        String string2 = Util.getExtension(string);
        for (Parser object : parsers) {
            Match match = new Match(object);
            if (!Collections.disjoint(list, object.getTypes())) {
                match.mimeMatch = true;
            }
            for (String string3 : ParseService.getExtensions(indexingConfig, object)) {
                if (!string3.toLowerCase().equals(string2)) continue;
                match.extMatch = true;
                break;
            }
            if (!match.mimeMatch && !match.extMatch) continue;
            treeSet.add(match);
        }
        List list2 = Util.createEmptyList(treeSet);
        for (Match match : treeSet) {
            list2.add(match.parser);
        }
        return list2;
    }

    public static ParseResult parse(IndexingConfig indexingConfig, File file, String string, Path path, IndexingReporter indexingReporter, Cancelable cancelable) throws ParseException, CheckedOutOfMemoryError {
        ParseContext parseContext = new ParseContext(string, indexingReporter, cancelable);
        for (PatternAction patternAction : indexingConfig.getPatternActions()) {
            if (patternAction.getAction() != PatternAction.MatchAction.DETECT_MIME || !patternAction.matches(string, path, true)) continue;
            try {
                List<Parser> list = ParseService.getSortedMatchingParsers(indexingConfig, file, string);
                for (Parser parser : list) {
                    try {
                        return ParseService.doParse(indexingConfig, parser, file, parseContext);
                    }
                    catch (ParseException parseException) {
                    }
                }
            }
            catch (IOException iOException) {
            }
            catch (InvalidPathException invalidPathException) {
            }
        }
        Parser parser = ParseService.findParserByName(indexingConfig, file.getName());
        if (parser != null) {
            return ParseService.doParse(indexingConfig, parser, file, parseContext);
        }
        if (indexingConfig.isIndexFilenames()) {
            return new ParseResult("").setParserName(FILENAME_PARSER);
        }
        throw new ParseException(Msg.parser_not_found.get());
    }

    private static ParseResult doParse(IndexingConfig indexingConfig, Parser parser, final File file, ParseContext parseContext) throws ParseException, CheckedOutOfMemoryError {
        try {
            Object object;
            ParseResult parseResult = null;
            if (ProgramConf.Bool.DryRun.get()) {
                parseResult = new ParseResult("");
            } else if (parser instanceof StreamParser) {
                object = null;
                try {
                    object = ParseService.isZipEntry(file) ? new TFileInputStream(file) : new FileInputStream(file);
                    StreamParser streamParser = (StreamParser)parser;
                    parseResult = streamParser.parse((InputStream)object, parseContext);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new ParseException(fileNotFoundException);
                }
                finally {
                    Closeables.closeQuietly((Closeable)object);
                }
            } else if (parser instanceof FileParser) {
                object = (FileParser)parser;
                if (ParseService.isZipEntry(file)) {
                    TFile tFile = (TFile)file;
                    File file2 = null;
                    try {
                        file2 = indexingConfig.createDerivedTempFile(tFile.getName());
                        tFile.cp(file2);
                        parseResult = ((FileParser)object).parse(file2, parseContext);
                    }
                    catch (RuntimeException runtimeException) {
                        throw new ParseException(runtimeException);
                    }
                    catch (IndexingException indexingException) {
                        throw new ParseException(indexingException.getIOException());
                    }
                    catch (IOException iOException) {
                        throw new ParseException(iOException);
                    }
                    finally {
                        if (file2 != null) {
                            file2.delete();
                        }
                    }
                } else {
                    parseResult = ((FileParser)object).parse(file, parseContext);
                }
            } else {
                throw new IllegalStateException();
            }
            object = parser.getClass().getSimpleName();
            return parseResult.setParserName((String)object);
        }
        catch (RuntimeException runtimeException) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (StackTraceWindow.windowCount < 1) {
                        AppUtil.showStackTrace(runtimeException, file);
                    }
                }
            });
            throw new ParseException(runtimeException);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new CheckedOutOfMemoryError(outOfMemoryError);
        }
    }

    private static boolean isZipEntry(File file) {
        return file instanceof TFile && ((TFile)file).isEntry();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String renderText(IndexingConfig indexingConfig, File file, String string, String string2) throws ParseException, CheckedOutOfMemoryError {
        Util.checkThat(!(file instanceof TFile));
        if (string2.equals(FILENAME_PARSER)) {
            return "";
        }
        for (Parser parser : parsers) {
            if (!parser.getClass().getSimpleName().equals(string2)) continue;
            try {
                if (parser instanceof StreamParser) {
                    String string3;
                    FileInputStream fileInputStream = null;
                    try {
                        fileInputStream = new FileInputStream(file);
                        string3 = ((StreamParser)parser).renderText(fileInputStream, string);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        try {
                            throw new ParseException(fileNotFoundException);
                        }
                        catch (Throwable throwable) {
                            Closeables.closeQuietly(fileInputStream);
                            throw throwable;
                        }
                    }
                    Closeables.closeQuietly((Closeable)fileInputStream);
                    return string3;
                }
                if (!(parser instanceof FileParser)) continue;
                return ((FileParser)parser).renderText(file, string);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                throw new CheckedOutOfMemoryError(outOfMemoryError);
            }
        }
        throw new ParseException(Msg.parser_not_found.get());
    }

    private static Parser findParserByName(IndexingConfig indexingConfig, String string) {
        String string2 = Util.getExtension(string);
        for (Parser parser : parsers) {
            for (String string3 : ParseService.getExtensions(indexingConfig, parser)) {
                if (!string3.toLowerCase().equals(string2)) continue;
                return parser;
            }
        }
        return null;
    }

    private static Collection<String> getExtensions(IndexingConfig indexingConfig, Parser parser) {
        if (parser == textParser) {
            return indexingConfig.getTextExtensions();
        }
        if (parser == htmlParser) {
            return indexingConfig.getHtmlExtensions();
        }
        return parser.getExtensions();
    }

    public static boolean canParseByName(IndexingConfig indexingConfig, String string) {
        return indexingConfig.isIndexFilenames() || ParseService.findParserByName(indexingConfig, string) != null;
    }

    public static boolean isBuiltInExtension(IndexingConfig indexingConfig, String string) {
        for (Parser parser : parsers) {
            if (parser == textParser) continue;
            Collection<String> collection = parser == htmlParser ? indexingConfig.getHtmlExtensions() : parser.getExtensions();
            for (String string2 : collection) {
                if (!string2.toLowerCase().equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    static List<String> getPossibleMimeTypes(File file) throws IOException {
        List list;
        Object object = null;
        try {
            object = new TFileInputStream(file);
            object = new BufferedInputStream((InputStream)object);
            Collection collection = mimeDetector.getMimeTypes((InputStream)object);
            Collection<String> collection2 = textParser.getTypes();
            List list2 = Util.createEmptyList(collection, collection2);
            for (Object e : collection) {
                list2.add(e.toString().toLowerCase(Locale.ENGLISH));
            }
            if (TextDetector.isText((InputStream)object)) {
                list2.addAll(collection2);
            }
            list = list2;
        }
        catch (Throwable throwable) {
            Closeables.closeQuietly(object);
            throw throwable;
        }
        Closeables.closeQuietly((Closeable)object);
        return list;
    }

    static org.apache.tika.parser.ParseContext tikaContext() {
        return new org.apache.tika.parser.ParseContext();
    }

    static {
        Parser[] parserArray = new Parser[22];
        textParser = new TextParser();
        parserArray[0] = textParser;
        htmlParser = new HtmlParser();
        parserArray[1] = htmlParser;
        parserArray[2] = new ExifParser();
        parserArray[3] = new MP3Parser();
        parserArray[4] = new FLACParser();
        parserArray[5] = new AbiWordParser();
        parserArray[6] = new PdfParser();
        parserArray[7] = new RtfParser();
        parserArray[8] = new SvgParser();
        parserArray[9] = new EpubParser();
        parserArray[10] = new ChmParser();
        parserArray[11] = new OpenOfficeParser.OpenOfficeWriterParser();
        parserArray[12] = new OpenOfficeParser.OpenOfficeCalcParser();
        parserArray[13] = new OpenOfficeParser.OpenOfficeDrawParser();
        parserArray[14] = new OpenOfficeParser.OpenOfficeImpressParser();
        parserArray[15] = new MSOfficeParser.MSWordParser();
        parserArray[16] = new MSExcelParser();
        parserArray[17] = new MSOfficeParser.MSPowerPointParser();
        parserArray[18] = new MSOfficeParser.MSVisioParser();
        parserArray[19] = new MSOffice2007Parser.MSWord2007Parser();
        parserArray[20] = new MSOffice2007Parser.MSExcel2007Parser();
        parserArray[21] = new MSOffice2007Parser.MSPowerPoint2007Parser();
        parsers = Util.createList(1, parserArray);
    }
}

