/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.model.parse;

import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import net.sourceforge.docfetcher.enums.Msg;
import net.sourceforge.docfetcher.model.parse.MediaType;
import net.sourceforge.docfetcher.model.parse.ParseContext;
import net.sourceforge.docfetcher.model.parse.ParseException;
import net.sourceforge.docfetcher.model.parse.ParseResult;
import net.sourceforge.docfetcher.model.parse.ParseService;
import net.sourceforge.docfetcher.model.parse.StreamParser;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.rtf.RTFParser;
import org.apache.tika.sax.BodyContentHandler;

final class RtfParser
extends StreamParser {
    private static final Collection<String> extensions = Collections.singleton("rtf");
    private static final Collection<String> types = MediaType.Col.text("rtf");

    RtfParser() {
    }

    @Override
    protected ParseResult parse(InputStream inputStream, ParseContext parseContext) throws ParseException {
        BodyContentHandler bodyContentHandler = new BodyContentHandler(-1);
        Metadata metadata = new Metadata();
        try {
            org.apache.tika.parser.ParseContext parseContext2 = ParseService.tikaContext();
            TikaConfig tikaConfig = new TikaConfig(new ClassLoader(this){

                @Override
                protected URL findResource(String string) {
                    if ("tika-mimetypes.xml".equals(string)) {
                        return this.getResource("org/apache/tika/mime/tika-mimetypes.xml");
                    }
                    return null;
                }
            });
            parseContext2.set(TikaConfig.class, tikaConfig);
            new RTFParser().parse(inputStream, bodyContentHandler, metadata, parseContext2);
            return new ParseResult(bodyContentHandler.toString()).addAuthor(metadata.get(TikaCoreProperties.CREATOR)).setTitle(metadata.get(TikaCoreProperties.TITLE)).addMiscMetadata(metadata.get("subject")).addMiscMetadata(metadata.get(TikaCoreProperties.KEYWORDS));
        }
        catch (AssertionError assertionError) {
            throw new ParseException((Throwable)((Object)assertionError));
        }
        catch (Exception exception) {
            throw new ParseException(exception);
        }
    }

    @Override
    protected String renderText(InputStream inputStream, String string) throws ParseException {
        BodyContentHandler bodyContentHandler = new BodyContentHandler(-1);
        Metadata metadata = new Metadata();
        try {
            new RTFParser().parse(inputStream, bodyContentHandler, metadata, ParseService.tikaContext());
            return bodyContentHandler.toString();
        }
        catch (AssertionError assertionError) {
            throw new ParseException((Throwable)((Object)assertionError));
        }
        catch (Exception exception) {
            throw new ParseException(exception);
        }
    }

    @Override
    protected Collection<String> getExtensions() {
        return extensions;
    }

    @Override
    protected Collection<String> getTypes() {
        return types;
    }

    @Override
    public String getTypeLabel() {
        return Msg.filetype_rtf.get();
    }
}

