/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.model.parse;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import net.htmlparser.jericho.CharacterReference;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.Source;
import net.sourceforge.docfetcher.enums.Msg;
import net.sourceforge.docfetcher.model.parse.MediaType;
import net.sourceforge.docfetcher.model.parse.ParseContext;
import net.sourceforge.docfetcher.model.parse.ParseException;
import net.sourceforge.docfetcher.model.parse.ParseResult;
import net.sourceforge.docfetcher.model.parse.StreamParser;

final class SvgParser
extends StreamParser {
    private static final Collection<String> extensions = Collections.singleton("svg");
    private static final Collection<String> types = MediaType.Col.text("xml");

    SvgParser() {
    }

    @Override
    protected ParseResult parse(InputStream inputStream, ParseContext parseContext) throws ParseException {
        try {
            Source source = new Source(inputStream);
            source.setLogger(null);
            return new ParseResult(source.getTextExtractor().toString()).setTitle(this.getElementContent(source, "dc:title")).addAuthor(this.getElementContent(source, "dc:creator"));
        }
        catch (IOException iOException) {
            throw new ParseException(iOException);
        }
    }

    @Override
    protected String renderText(InputStream inputStream, String string) throws ParseException {
        try {
            Source source = new Source(inputStream);
            source.setLogger(null);
            return source.getTextExtractor().toString();
        }
        catch (IOException iOException) {
            throw new ParseException(iOException);
        }
    }

    private String getElementContent(Source source, String string) {
        Element element = source.getNextElement(0, string);
        return element == null ? null : CharacterReference.decode((CharSequence)element.getTextExtractor().toString());
    }

    @Override
    protected Collection<String> getExtensions() {
        return extensions;
    }

    @Override
    protected Collection<String> getTypes() {
        return types;
    }

    @Override
    public String getTypeLabel() {
        return Msg.filetype_svg.get();
    }
}

