/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.model.parse;

import com.google.common.io.Closeables;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import de.schlichtherle.truezip.file.TVFS;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.TextExtractor;
import net.sourceforge.docfetcher.TestFiles;
import net.sourceforge.docfetcher.model.parse.ParseResult;
import net.sourceforge.docfetcher.util.Util;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.text.PDFTextStripper;
import org.apache.poi.EmptyFileException;
import org.apache.poi.extractor.ExtractorFactory;
import org.apache.poi.hwpf.OldWordFileFormatException;
import org.apache.poi.hwpf.extractor.WordExtractor;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.poifs.eventfilesystem.POIFSReader;
import org.apache.poi.poifs.eventfilesystem.POIFSReaderEvent;
import org.apache.poi.poifs.eventfilesystem.POIFSReaderListener;
import org.junit.Assert;
import org.junit.Test;

public final class TestParseFromZip {
    @Test
    public void testZippedOffice() throws Exception {
        new ZipAndRun(this, TestFiles.doc){

            @Override
            protected void handleInputStream(InputStream inputStream) throws Exception {
                POIFSReader pOIFSReader = new POIFSReader();
                pOIFSReader.registerListener(new POIFSReaderListener(this){

                    public void processPOIFSReaderEvent(POIFSReaderEvent pOIFSReaderEvent) {
                    }
                }, "\u0005SummaryInformation");
                pOIFSReader.read(inputStream);
            }
        };
        new ZipAndRun(this, TestFiles.doc){

            @Override
            protected void handleInputStream(InputStream inputStream) throws Exception {
                WordExtractor wordExtractor = null;
                try {
                    wordExtractor = new WordExtractor(inputStream);
                    wordExtractor.getText();
                }
                catch (Throwable throwable) {
                    Closeables.closeQuietly(wordExtractor);
                    throw throwable;
                }
                Closeables.closeQuietly((Closeable)wordExtractor);
            }
        };
    }

    @Test(expected=OldWordFileFormatException.class)
    public void testOldWordDoc() throws Exception {
        new ZipAndRun(this, TestFiles.doc_old){

            @Override
            protected void handleInputStream(InputStream inputStream) throws Exception {
                WordExtractor wordExtractor = null;
                try {
                    wordExtractor = new WordExtractor(inputStream);
                    wordExtractor.getText();
                }
                catch (Throwable throwable) {
                    Closeables.closeQuietly(wordExtractor);
                    throw throwable;
                }
                Closeables.closeQuietly((Closeable)wordExtractor);
            }
        };
    }

    @Test(expected=EmptyFileException.class)
    public void testZippedOfficeFail() throws Exception {
        new ZipAndRun(this, TestFiles.doc){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void handleInputStream(InputStream inputStream) throws Exception {
                POIFSReader pOIFSReader = new POIFSReader();
                pOIFSReader.registerListener(new POIFSReaderListener(this){

                    public void processPOIFSReaderEvent(POIFSReaderEvent pOIFSReaderEvent) {
                    }
                }, "\u0005SummaryInformation");
                pOIFSReader.read(inputStream);
                WordExtractor wordExtractor = null;
                try {
                    wordExtractor = new WordExtractor(inputStream);
                    wordExtractor.getText();
                }
                catch (Throwable throwable) {
                    Closeables.closeQuietly(wordExtractor);
                    throw throwable;
                }
                Closeables.closeQuietly((Closeable)wordExtractor);
            }
        };
    }

    @Test
    public void testZippedOffice2007() throws Exception {
        new ZipAndRun(this, TestFiles.docx){

            @Override
            protected void handleInputStream(InputStream inputStream) throws Exception {
                int n = ExtractorFactory.createExtractor((InputStream)inputStream).getText().length();
                Assert.assertEquals((long)659L, (long)n);
            }
        };
        new ZipAndRun(this, TestFiles.docx){

            @Override
            protected void handleInputStream(InputStream inputStream) throws Exception {
                OPCPackage oPCPackage = OPCPackage.open((InputStream)inputStream);
                oPCPackage.getPackageProperties();
                Closeables.closeQuietly((Closeable)oPCPackage);
            }
        };
    }

    @Test(expected=IOException.class)
    public void testZippedOffice2007Fail() throws Exception {
        new ZipAndRun(this, TestFiles.docx){

            @Override
            protected void handleInputStream(InputStream inputStream) throws Exception {
                int n = ExtractorFactory.createExtractor((InputStream)inputStream).getText().length();
                Assert.assertEquals((long)659L, (long)n);
                OPCPackage oPCPackage = OPCPackage.open((InputStream)inputStream);
                oPCPackage.getPackageProperties();
                Closeables.closeQuietly((Closeable)oPCPackage);
            }
        };
    }

    @Test
    public void testZippedHtml() throws Exception {
        new ZipAndRun(this, TestFiles.html){

            @Override
            protected void handleInputStream(InputStream inputStream) throws Exception {
                Source source = new Source(inputStream);
                source.fullSequentialParse();
                TextExtractor textExtractor = source.getTextExtractor();
                textExtractor.setIncludeAttributes(true);
                Assert.assertTrue((boolean)textExtractor.toString().contains("HTML file"));
            }
        };
    }

    @Test
    public void testZippedPdf() throws Exception {
        new ZipAndRun(this, TestFiles.multi_page_pdf){

            @Override
            protected void handleInputStream(InputStream inputStream) throws Exception {
                PDDocument pDDocument = PDDocument.load((InputStream)inputStream);
                PDFTextStripper pDFTextStripper = new PDFTextStripper();
                StringWriter stringWriter = new StringWriter();
                pDFTextStripper.setSortByPosition(true);
                pDFTextStripper.writeText(pDDocument, (Writer)stringWriter);
                PDDocumentInformation pDDocumentInformation = pDDocument.getDocumentInformation();
                ParseResult parseResult = new ParseResult(stringWriter.getBuffer()).setTitle(pDDocumentInformation.getTitle()).addAuthor(pDDocumentInformation.getAuthor()).addMiscMetadata(pDDocumentInformation.getSubject()).addMiscMetadata(pDDocumentInformation.getKeywords());
                String string = Util.join(Util.LS, "page 1", "page 2", "page 3");
                String string2 = parseResult.getContent().toString().trim();
                Assert.assertEquals((Object)string, (Object)string2);
            }
        };
    }

    private static abstract class ZipAndRun {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ZipAndRun(TestFiles testFiles) throws Exception {
            TFile tFile = new TFile(testFiles.getPath());
            File file = Util.createTempDir();
            TFile tFile2 = new TFile(file, "archive.zip");
            tFile2.mkdir();
            TFile tFile3 = new TFile((File)tFile2, tFile.getName());
            tFile.cp((File)tFile3);
            TFileInputStream tFileInputStream = new TFileInputStream((File)tFile3);
            try {
                this.handleInputStream((InputStream)tFileInputStream);
            }
            finally {
                Closeables.closeQuietly((Closeable)tFileInputStream);
                TVFS.umount((TFile)tFile2);
                Util.deleteRecursively(file);
            }
        }

        protected abstract void handleInputStream(InputStream var1) throws Exception;
    }
}

