/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.model.parse;

import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.Source;
import net.sourceforge.docfetcher.enums.Msg;
import net.sourceforge.docfetcher.model.parse.ParseException;
import net.sourceforge.docfetcher.util.CharsetDetectorHelper;

final class UtilParser {
    private UtilParser() {
    }

    public static Source getSource(InputStream inputStream) throws IOException {
        StringReader stringReader = new StringReader(CharsetDetectorHelper.toString(inputStream));
        Source source = new Source((Reader)stringReader);
        return source;
    }

    public static Source getSource(ZipFile zipFile, String string) throws IOException, ParseException {
        ZipEntry zipEntry = zipFile.getEntry(string);
        if (zipEntry == null && (zipEntry = zipFile.getEntry(string.replace("\\", "/"))) == null) {
            throw new ParseException(Msg.file_corrupted.get());
        }
        InputStream inputStream = zipFile.getInputStream(zipEntry);
        Source source = UtilParser.getSource(inputStream);
        Closeables.closeQuietly((Closeable)inputStream);
        source.setLogger(null);
        return source;
    }

    public static String extract(Element element) {
        if (element == null) {
            return null;
        }
        return element.getContent().getTextExtractor().toString();
    }

    public static String render(Segment segment) {
        return segment.getRenderer().setIncludeHyperlinkURLs(false).toString();
    }

    public static void closeZipFile(ZipFile zipFile) {
        if (zipFile == null) {
            return;
        }
        try {
            zipFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

