/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.model.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.docfetcher.model.search.Range;
import net.sourceforge.docfetcher.util.Util;

public final class HighlightedString {
    private final List<String> strings = new ArrayList<String>(1);
    private final List<Range> ranges;
    private int length;

    HighlightedString(String string, List<Range> list) {
        Util.checkNotNull(string, list);
        this.strings.add(string);
        this.length = string.length();
        this.ranges = list;
    }

    public String getString() {
        StringBuilder stringBuilder = new StringBuilder(this.length);
        for (String string : this.strings) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public List<Range> getRanges() {
        return Collections.unmodifiableList(this.ranges);
    }

    public int length() {
        return this.length;
    }

    public boolean isEmpty() {
        return this.length == 0;
    }

    public int getRangeCount() {
        return this.ranges.size();
    }

    public void add(HighlightedString highlightedString) {
        Util.checkNotNull(highlightedString);
        this.strings.addAll(highlightedString.strings);
        for (Range range : highlightedString.ranges) {
            this.ranges.add(new Range(range.start + this.length, range.length));
        }
        this.length += highlightedString.length;
    }
}

