/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.model.search;

import java.util.Collection;
import net.sourceforge.docfetcher.gui.filter.FilesizeUnit;
import net.sourceforge.docfetcher.model.LuceneIndex;
import net.sourceforge.docfetcher.model.parse.Parser;
import net.sourceforge.docfetcher.util.Util;

public final class WebQuery {
    final String query;
    final int pageIndex;
    Long minSize;
    Long maxSize;
    Collection<Parser> parsers;
    Collection<LuceneIndex> indexes;

    public WebQuery(String string, int n) {
        this.query = Util.checkNotNull(string);
        this.pageIndex = n;
    }

    public void setMinimumSize(Long l, FilesizeUnit filesizeUnit) {
        this.minSize = FilesizeUnit.Byte.convert(l, filesizeUnit);
    }

    public void setMaximumSize(Long l, FilesizeUnit filesizeUnit) {
        this.maxSize = FilesizeUnit.Byte.convert(l, filesizeUnit);
    }

    public void setIncludedTypes(Collection<Parser> collection) {
        this.parsers = collection;
    }

    public void setIncludedIndexes(Collection<LuceneIndex> collection) {
        this.indexes = collection;
    }
}

