/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.util;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.sun.jna.platform.win32.Shell32Util;
import java.awt.AWTException;
import java.awt.Robot;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.sourceforge.docfetcher.enums.ProgramConf;
import net.sourceforge.docfetcher.enums.SettingsConf;
import net.sourceforge.docfetcher.enums.SystemConf;
import net.sourceforge.docfetcher.gui.KeyCodeTranslator;
import net.sourceforge.docfetcher.util.Util;
import net.sourceforge.docfetcher.util.UtilGui;
import net.sourceforge.docfetcher.util.gui.dialog.StackTraceWindow;
import org.apache.commons.codec.digest.DigestUtils;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public final class AppUtil {
    private static File appDataDir;
    private static Display display;
    private static boolean initialized;

    private AppUtil() {
    }

    public static void setDisplay(Display display) {
        Util.checkNotNull(display);
        Util.checkThat(AppUtil.display == null);
        AppUtil.display = display;
        display.disposeExec(new Runnable(){

            @Override
            public void run() {
                display = null;
            }
        });
    }

    public static void checkConstInitialized() {
        if (!initialized) {
            for (Const const_ : Const.values()) {
                if (const_.value != null) continue;
                throw new IllegalStateException("Uninitialized constant: " + const_.name());
            }
            initialized = true;
        }
    }

    public static void ensureNoDisplay() {
        if (display != null) {
            throw new IllegalStateException("Display has already been initialized.");
        }
    }

    private static void ensureDisplay() {
        if (display == null) {
            throw new IllegalStateException("Display has not been initialized.");
        }
    }

    public static boolean checkSingleInstance() {
        AppUtil.checkConstInitialized();
        AppUtil.ensureNoDisplay();
        String string = Const.USER_DIR_PATH.value;
        String string2 = DigestUtils.shaHex((String)string);
        String string3 = Util.encodeBase64(Const.PROGRAM_NAME.value);
        String string4 = Util.encodeBase64(System.getProperty("user.name"));
        String string5 = Util.encodeBase64(string);
        String string6 = String.format(".lock-%s-%s-%s-%s.", string2, string3, string4, string5);
        string6 = string6.substring(0, Math.min(string6.length(), 250));
        File file = new File(Util.TEMP_DIR, string6);
        if (file.exists()) {
            if (SettingsConf.Bool.AllowOnlyOneInstance.get()) {
                AppUtil.sendHotkeyToFront();
                return false;
            }
            Display display = new Display();
            Shell shell = new Shell(display);
            MessageBox messageBox = new MessageBox(shell, 49444);
            messageBox.setText(Messages.confirm_operation.value);
            messageBox.setMessage(Messages.program_running_launch_another.format(ProgramConf.Str.AppName.get()));
            int n = messageBox.open();
            display.dispose();
            if (n != 32) {
                AppUtil.sendHotkeyToFront();
                return false;
            }
        } else {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        file.deleteOnExit();
        return true;
    }

    public static void sendHotkeyToFront() {
        try {
            int n = SettingsConf.IntArray.Hotkey.get()[0];
            n = KeyCodeTranslator.translateSWTKey(n);
            int n2 = SettingsConf.IntArray.Hotkey.get()[1];
            n2 = KeyCodeTranslator.translateSWTKey(n2);
            Robot robot = new Robot();
            robot.keyPress(n);
            robot.keyPress(n2);
            robot.delay(500);
            robot.keyRelease(n2);
            robot.keyRelease(n);
        }
        catch (AWTException aWTException) {
            AppUtil.showStackTrace(aWTException);
        }
    }

    private static Shell getActiveShell() {
        AppUtil.ensureDisplay();
        Shell shell = display.getActiveShell();
        if (shell != null) {
            return shell;
        }
        Shell[] shellArray = display.getShells();
        if (shellArray.length != 0) {
            return shellArray[0];
        }
        return null;
    }

    public static void showErrorOnStart(String string, boolean bl) {
        int n = 0x20 | (bl ? 1 : 8);
        AppUtil.showErrorOnStart(string, n);
    }

    public static int showErrorOnStart(String string, int n) {
        AppUtil.checkConstInitialized();
        AppUtil.ensureNoDisplay();
        Display display = new Display();
        Shell shell = new Shell(display);
        MessageBox messageBox = new MessageBox(shell, n);
        messageBox.setText(Messages.system_error.value);
        messageBox.setMessage(string);
        int n2 = messageBox.open();
        shell.dispose();
        display.dispose();
        return n2;
    }

    public static boolean showConfirmation(final String string, final boolean bl) {
        AppUtil.checkConstInitialized();
        AppUtil.ensureDisplay();
        class MyRunnable
        implements Runnable {
            private boolean answer;

            MyRunnable() {
            }

            @Override
            public void run() {
                int n = 288;
                MessageBox messageBox = new MessageBox(AppUtil.getActiveShell(), n |= bl ? 8 : 4);
                messageBox.setText(Messages.confirm_operation.value);
                messageBox.setMessage(string);
                this.answer = messageBox.open() == 32;
            }
        }
        MyRunnable myRunnable = new MyRunnable();
        UtilGui.runSwtSafe(display, (Runnable)myRunnable);
        return myRunnable.answer;
    }

    public static void showInfo(final String string) {
        AppUtil.checkConstInitialized();
        AppUtil.ensureDisplay();
        UtilGui.runSwtSafe(display, new Runnable(){

            @Override
            public void run() {
                MessageBox messageBox = new MessageBox(AppUtil.getActiveShell(), 34);
                messageBox.setMessage(string);
                messageBox.open();
            }
        });
    }

    public static void showError(final String string, final boolean bl, final boolean bl2) {
        AppUtil.checkConstInitialized();
        AppUtil.ensureDisplay();
        UtilGui.runSwtSafe(display, new Runnable(){

            @Override
            public void run() {
                int n = 32;
                MessageBox messageBox = new MessageBox(AppUtil.getActiveShell(), n |= bl ? 1 : 8);
                messageBox.setText(bl2 ? Messages.invalid_operation.value : Messages.system_error.value);
                messageBox.setMessage(string);
                messageBox.open();
            }
        });
    }

    public static void showStackTraceInOwnDisplay(Throwable throwable) {
        AppUtil.checkConstInitialized();
        AppUtil.ensureNoDisplay();
        Display display = new Display();
        AppUtil.showStackTrace(display, throwable, null);
        display.dispose();
    }

    public static void showStackTrace(Throwable throwable) {
        AppUtil.checkConstInitialized();
        AppUtil.ensureDisplay();
        AppUtil.showStackTrace(Display.getDefault(), throwable, null);
    }

    public static void showStackTrace(Throwable throwable, File file) {
        AppUtil.checkConstInitialized();
        AppUtil.ensureDisplay();
        AppUtil.showStackTrace(Display.getDefault(), throwable, file);
    }

    private static void showStackTrace(final Display display, final Throwable throwable, File file) {
        throwable.printStackTrace();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("program.name=" + Const.PROGRAM_NAME.value + Util.LS);
        stringBuilder.append("program.version=" + Const.PROGRAM_VERSION.value + Util.LS);
        stringBuilder.append("program.build=" + Const.PROGRAM_BUILD_DATE.value + Util.LS);
        stringBuilder.append("program.portable=" + Const.IS_PORTABLE.asBoolean() + Util.LS);
        String[] stringArray = new String[]{"java.runtime.name", "java.runtime.version", "java.version", "sun.arch.data.model", "os.arch", "os.name", "os.version", "user.language"};
        for (String object2 : stringArray) {
            stringBuilder.append(object2 + "=" + System.getProperty(object2) + Util.LS);
        }
        if (file != null) {
            stringBuilder.append("file=" + file.getPath() + Util.LS);
        }
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        stringBuilder.append(stringWriter.toString());
        final String string = stringBuilder.toString();
        String string2 = new SimpleDateFormat("yyyyMMdd-HHmm").format(new Date());
        String string3 = "stacktrace_" + string2 + ".txt";
        final File file2 = new File(AppUtil.getAppDataDir(), string3);
        try {
            Files.write((CharSequence)string, (File)file2, (Charset)Charsets.UTF_8);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        UtilGui.runSwtSafe(display, new Runnable(){

            @Override
            public void run() {
                if (StackTraceWindow.windowCount >= 5) {
                    return;
                }
                StackTraceWindow stackTraceWindow = new StackTraceWindow(display);
                stackTraceWindow.setTitle(throwable.getClass().getSimpleName());
                String string4 = Util.getSystemAbsPath(file2);
                String string2 = String.format("<a href=\"%s\">%s</a>", string4, string4);
                String string3 = Messages.program_died_stacktrace_written.format(string2);
                stackTraceWindow.setText(string3);
                Image image = display.getSystemImage(8);
                stackTraceWindow.setTitleImage(image);
                stackTraceWindow.setStackTrace(Util.ensureLinuxLineSep(string));
                stackTraceWindow.open();
            }
        });
    }

    public static File getAppDataDir() {
        Object object;
        AppUtil.checkConstInitialized();
        if (appDataDir != null) {
            return appDataDir;
        }
        String string = System.getenv("DOCFETCHER_HOME");
        if (string != null) {
            object = Util.getCanonicalFile(string);
            if (!((File)object).exists()) {
                ((File)object).mkdirs();
            }
            if (((File)object).isDirectory()) {
                appDataDir = object;
                return object;
            }
        }
        object = Const.PROGRAM_NAME.value;
        File file = null;
        if (Const.IS_DEVELOPMENT_VERSION.asBoolean()) {
            file = new File("bin");
        } else if (Const.IS_PORTABLE.asBoolean()) {
            file = new File(Const.USER_DIR_PATH.value);
        } else if (Util.IS_WINDOWS) {
            String string2 = System.getenv("APPDATA");
            if (string2 == null) {
                string2 = Shell32Util.getFolderPath((int)26);
            }
            if (string2 == null) {
                throw new IllegalStateException("Cannot find application data folder.");
            }
            file = new File(string2, (String)object);
        } else if (Util.IS_LINUX || Util.IS_MAC_OS_X) {
            file = new File(Util.USER_HOME_PATH, "." + ((String)object).toLowerCase());
        } else {
            throw new IllegalStateException();
        }
        file.mkdirs();
        appDataDir = file;
        return file;
    }

    public static boolean isPortable() {
        AppUtil.checkConstInitialized();
        return Const.IS_PORTABLE.asBoolean();
    }

    public static String getImageDir() {
        AppUtil.checkConstInitialized();
        if (Const.IS_DEVELOPMENT_VERSION.asBoolean()) {
            return "dist/img";
        }
        if (Util.IS_MAC_OS_X && !Const.IS_PORTABLE.asBoolean()) {
            return "../Resources/img";
        }
        return "img";
    }

    public static File getLangDir() {
        if (SystemConf.Bool.IsDevelopmentVersion.get()) {
            return new File("dist/lang");
        }
        if (Util.IS_MAC_OS_X && !SystemConf.Bool.IsPortable.get()) {
            return new File("../Resources/lang");
        }
        return new File("lang");
    }

    public static boolean canWriteToDirectory(File file) {
        if (!file.exists() || !file.isDirectory()) {
            return false;
        }
        File file2 = new File(file, ".write-test-" + System.currentTimeMillis());
        try {
            if (file2.createNewFile()) {
                file2.delete();
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    static {
        initialized = false;
    }

    public static enum Const {
        PROGRAM_NAME,
        PROGRAM_VERSION,
        PROGRAM_BUILD_DATE,
        USER_DIR_PATH,
        IS_PORTABLE,
        IS_DEVELOPMENT_VERSION;

        private String value;

        public String get() {
            return this.value;
        }

        public void set(String string) {
            Util.checkNotNull(string);
            if (this.value != null) {
                throw new UnsupportedOperationException("Constant cannot be set twice: " + this.name());
            }
            this.value = this == IS_PORTABLE ? String.valueOf(Boolean.parseBoolean(string)) : string;
        }

        public void set(boolean bl) {
            this.set(String.valueOf(bl));
        }

        private boolean asBoolean() {
            return Boolean.parseBoolean(this.value);
        }

        public static void autoInit() {
            if (initialized) {
                return;
            }
            PROGRAM_NAME.set("DocFetcher");
            PROGRAM_VERSION.set("Unspecified");
            PROGRAM_BUILD_DATE.set("Unspecified");
            USER_DIR_PATH.set(Util.USER_DIR_PATH);
            IS_PORTABLE.set("true");
            IS_DEVELOPMENT_VERSION.set("true");
            for (Const const_ : Const.values()) {
                if (const_.value != null) continue;
                throw new IllegalStateException();
            }
            initialized = true;
        }

        public static void clear() {
            for (Const const_ : Const.values()) {
                const_.value = null;
            }
            initialized = false;
        }
    }

    public static enum Messages {
        system_error("System Error"),
        confirm_operation("Confirm Operation"),
        invalid_operation("Invalid Operation"),
        program_died_stacktrace_written("This program just died! The stacktrace below has been written to {0}."),
        program_running_launch_another("It seems an instance of {0} was not terminated cleanly or is still running. Do you want to launch another instance?"),
        ok("&OK"),
        cancel("&Cancel");

        private static int setCount;
        private String value;

        private Messages(String string2) {
            this.value = string2;
        }

        public String get() {
            return this.value;
        }

        public void set(String string) {
            this.value = Util.checkNotNull(string);
            ++setCount;
        }

        private String format(Object ... objectArray) {
            return MessageFormat.format(this.value, objectArray);
        }

        public static void checkInitialized() {
            Util.checkThat(Messages.values().length == setCount);
        }

        static {
            setCount = 0;
        }
    }
}

