/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.util;

import com.google.common.base.Charsets;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Properties;
import org.mozilla.universalchardet.UniversalDetector;

public final class CharsetDetectorHelper {
    public static String charsetOverride = "";
    private static UniversalDetector charsetDetector;

    private CharsetDetectorHelper() {
    }

    public static Properties load(File file) throws IOException {
        byte[] byArray = Files.toByteArray((File)file);
        String string = CharsetDetectorHelper.toString(byArray);
        Properties properties = new Properties();
        properties.load(new StringReader(string));
        return properties;
    }

    public static String toString(InputStream inputStream) throws IOException {
        byte[] byArray = ByteStreams.toByteArray((InputStream)inputStream);
        return CharsetDetectorHelper.toString(byArray);
    }

    public static String toString(File file) throws IOException {
        byte[] byArray = Files.toByteArray((File)file);
        return CharsetDetectorHelper.toString(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(byte[] byArray) throws IOException {
        if (!charsetOverride.trim().isEmpty()) {
            try {
                return new String(byArray, charsetOverride.trim());
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                throw new IOException("Charset not found: " + charsetOverride.trim());
            }
        }
        if (charsetDetector == null) {
            charsetDetector = new UniversalDetector(null);
        }
        byte[] byArray2 = new byte[4096];
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        String string = null;
        try {
            int n;
            while ((n = byteArrayInputStream.read(byArray2)) > 0 && !charsetDetector.isDone()) {
                charsetDetector.handleData(byArray2, 0, n);
            }
            charsetDetector.dataEnd();
            string = charsetDetector.getDetectedCharset();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            string = null;
        }
        finally {
            charsetDetector.reset();
        }
        try {
            return string == null ? new String(byArray, Charsets.ISO_8859_1) : new String(byArray, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(byArray, Charsets.ISO_8859_1);
        }
        catch (NegativeArraySizeException negativeArraySizeException) {
            throw new IOException("File too large or corrupted for charset decoding", negativeArraySizeException);
        }
    }
}

