/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import net.sourceforge.docfetcher.util.Util;

public final class Event<T> {
    private boolean enabled = true;
    private final List<Listener<T>> listeners = new CopyOnWriteArrayList<Listener<T>>();
    private static int hold = 0;
    private static Set<Listener<?>> cachedListeners;

    public void add(Listener<T> listener) {
        this.listeners.add(listener);
    }

    public void addAll(Collection<Listener<T>> collection) {
        this.listeners.addAll(collection);
    }

    public void remove(Listener<T> listener) {
        this.listeners.remove(listener);
    }

    public void removeAllListeners() {
        this.listeners.clear();
    }

    public List<Listener<T>> getListeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    public int getListenerCount() {
        return this.listeners.size();
    }

    public void fire(T t) {
        if (!this.enabled) {
            return;
        }
        this.doFireUpdate(t);
    }

    private void doFireUpdate(T t) {
        if (this.listeners.isEmpty()) {
            return;
        }
        if (hold == 0) {
            for (Listener<T> listener : this.listeners) {
                listener.update(t);
            }
        } else {
            for (Listener<T> listener : this.listeners) {
                if (cachedListeners == null) {
                    cachedListeners = new LinkedHashSet();
                }
                cachedListeners.add(listener);
                if (listener.cachedEventData == null) {
                    listener.cachedEventData = new ArrayList();
                }
                List list = listener.cachedEventData;
                switch (listener.eventDataPolicy.ordinal()) {
                    case 0: {
                        assert (list.size() <= 1);
                        if (list.isEmpty()) {
                            list.add(t);
                            break;
                        }
                        list.set(0, t);
                        break;
                    }
                    case 1: {
                        if (list.contains(t)) break;
                        list.add(t);
                        break;
                    }
                    case 2: {
                        list.add(t);
                    }
                }
            }
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public static void hold() {
        ++hold;
    }

    public static void flush() {
        if ((hold = Math.max(0, hold - 1)) > 0 || cachedListeners == null) {
            return;
        }
        for (Listener<?> listener : cachedListeners) {
            listener.updateFromCache();
        }
        cachedListeners = null;
    }

    public static <S> void redirect(Event<S> event, final Event<S> event2) {
        event.add(new Listener<S>(){

            @Override
            public void update(S s) {
                event2.fire(s);
            }
        });
    }

    public static abstract class Listener<T> {
        private List<T> cachedEventData;
        private final EventDataPolicy eventDataPolicy;

        public Listener() {
            this.eventDataPolicy = EventDataPolicy.UNIQUE;
        }

        public Listener(EventDataPolicy eventDataPolicy) {
            this.eventDataPolicy = Util.checkNotNull(eventDataPolicy);
        }

        public abstract void update(T var1);

        private void updateFromCache() {
            if (this.cachedEventData == null) {
                return;
            }
            for (T t : this.cachedEventData) {
                this.update(t);
            }
            this.cachedEventData = null;
        }
    }

    public static enum EventDataPolicy {
        SINGLE,
        UNIQUE,
        DUPLICATE;

    }
}

