/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.util.concurrent;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.sourceforge.docfetcher.util.Util;

public final class BlockingWrapper<T> {
    private final Lock lock = new ReentrantLock();
    private final Condition notNull = this.lock.newCondition();
    private T object;

    public T get() {
        this.lock.lock();
        try {
            while (this.object == null) {
                try {
                    this.notNull.await();
                }
                catch (InterruptedException interruptedException) {
                    T t = null;
                    this.lock.unlock();
                    return t;
                }
            }
            T t = this.object;
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void set(T t) {
        Util.checkNotNull(t);
        this.lock.lock();
        try {
            boolean bl = this.object == null;
            this.object = t;
            if (bl) {
                this.notNull.signal();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isNull() {
        this.lock.lock();
        try {
            boolean bl = this.object == null;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }
}

