/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.util.concurrent;

import net.sourceforge.docfetcher.util.Util;

public final class DelayedExecutor {
    private final long delay;
    private final Object lock = new Object();
    private Thread thread;
    private Runnable lastRunnable;
    private long lastTimestamp = 0L;

    public DelayedExecutor(long l) {
        Util.checkThat(l >= 0L);
        this.delay = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(Runnable runnable) {
        Util.checkNotNull(runnable);
        Object object = this.lock;
        synchronized (object) {
            this.lastRunnable = runnable;
            this.lastTimestamp = System.currentTimeMillis();
            if (this.thread != null) {
                return;
            }
            this.thread = new Thread(DelayedExecutor.class.getName()){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    long l = DelayedExecutor.this.delay;
                    while (true) {
                        try {
                            Thread.sleep(l);
                        }
                        catch (InterruptedException interruptedException) {
                            break;
                        }
                        Object object = DelayedExecutor.this.lock;
                        synchronized (object) {
                            long l2 = System.currentTimeMillis() - DelayedExecutor.this.lastTimestamp;
                            if (l2 > DelayedExecutor.this.delay) {
                                try {
                                    DelayedExecutor.this.lastRunnable.run();
                                }
                                finally {
                                    DelayedExecutor.this.lastRunnable = null;
                                    DelayedExecutor.this.thread = null;
                                }
                                break;
                            }
                            l = DelayedExecutor.this.delay - l2;
                        }
                    }
                }
            };
            this.thread.start();
        }
    }
}

