/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.util.gui;

import net.sourceforge.docfetcher.util.Event;
import net.sourceforge.docfetcher.util.UtilGui;
import net.sourceforge.docfetcher.util.gui.FormDataFactory;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Sash;

public abstract class FixedSashForm
extends Composite {
    public final Event<Boolean> evtFirstControlShown = new Event();
    private int limit = 50;
    private Sash sash;
    private Control firstControl;
    private Control secondControl;
    private boolean isHorizontal;
    private boolean isFirstFixed;
    private boolean isFirstVisible = true;
    private boolean isSmooth = false;

    public FixedSashForm(Composite composite, int n, int n2) {
        super(composite, 0);
        boolean bl = UtilGui.contains(n, 16384);
        this.isHorizontal = bl || UtilGui.contains(n, 131072);
        this.isFirstFixed = UtilGui.contains(n, 128) || bl;
        this.setLayout((Layout)new FormLayout());
        this.firstControl = this.createFirstControl(this);
        this.sash = new Sash((Composite)this, this.isHorizontal ? 512 : 256);
        this.secondControl = this.createSecondControl(this);
        this.sash.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (!FixedSashForm.this.isSmooth && selectionEvent.detail == 1) {
                    return;
                }
                FixedSashForm.this.setFixedDimension(FixedSashForm.this.isHorizontal ? selectionEvent.x : selectionEvent.y);
            }
        });
        FormDataFactory formDataFactory = FormDataFactory.getInstance();
        formDataFactory.margin(0).left().top();
        if (this.isHorizontal) {
            formDataFactory.bottom().right((Control)this.sash).applyTo(this.firstControl);
            formDataFactory.reset().margin(0).top().bottom();
            if (this.isFirstFixed) {
                formDataFactory.left(0, n2);
            } else {
                formDataFactory.right(100, -n2);
            }
            formDataFactory.applyTo((Control)this.sash);
            formDataFactory.left((Control)this.sash).right().applyTo(this.secondControl);
        } else {
            formDataFactory.bottom((Control)this.sash).right().applyTo(this.firstControl);
            formDataFactory.reset().margin(0).left().right();
            if (this.isFirstFixed) {
                formDataFactory.top(0, n2);
            } else {
                formDataFactory.bottom(100, -n2);
            }
            formDataFactory.applyTo((Control)this.sash);
            formDataFactory.top((Control)this.sash).bottom().applyTo(this.secondControl);
        }
    }

    public final int getSashWidth() {
        FormData formData = (FormData)this.sash.getLayoutData();
        return this.isHorizontal ? formData.width : formData.height;
    }

    public final void setSashWidth(int n) {
        FormData formData = (FormData)this.sash.getLayoutData();
        if (this.isHorizontal) {
            formData.width = n;
        } else {
            formData.height = n;
        }
        this.layout(false);
    }

    public final int getLimit() {
        return this.limit;
    }

    public final void setLimit(int n) {
        this.limit = n;
    }

    public final boolean isFirstControlVisible() {
        return this.isFirstVisible;
    }

    public final void setFirstControlVisible(boolean bl) {
        if (this.isFirstVisible == bl) {
            return;
        }
        this.isFirstVisible = bl;
        this.firstControl.setVisible(bl);
        this.sash.setVisible(bl);
        if (bl) {
            this.setLayout((Layout)new FormLayout());
        } else {
            StackLayout stackLayout = new StackLayout();
            stackLayout.topControl = this.secondControl;
            this.setLayout((Layout)stackLayout);
        }
        this.layout();
        this.evtFirstControlShown.fire(bl);
    }

    public final int getFixedDimension() {
        Control control = this.isFirstFixed ? this.firstControl : this.secondControl;
        Point point = control.getSize();
        return this.isHorizontal ? point.x : point.y;
    }

    public final void setFixedDimension(int n) {
        int n2;
        FixedSashForm fixedSashForm = this;
        Rectangle rectangle = fixedSashForm.getClientArea();
        Rectangle rectangle2 = this.sash.getBounds();
        FormData formData = (FormData)this.sash.getLayoutData();
        int n3 = fixedSashForm.limit;
        int n4 = -1;
        n4 = this.isHorizontal ? rectangle.width - rectangle2.width - n3 : rectangle.height - rectangle2.height - n3;
        n = Math.max(Math.min(n, n4), n3);
        int n5 = n2 = this.isHorizontal ? rectangle2.x : rectangle2.y;
        if (n == n2) {
            return;
        }
        if (this.isHorizontal) {
            if (this.isFirstFixed) {
                formData.left = new FormAttachment(0, n);
            } else {
                formData.right = new FormAttachment(100, -rectangle.width + rectangle2.width + n);
            }
        } else if (this.isFirstFixed) {
            formData.top = new FormAttachment(0, n);
        } else {
            formData.bottom = new FormAttachment(100, -rectangle.height + rectangle2.height + n);
        }
        fixedSashForm.layout();
    }

    public final boolean isSmooth() {
        return this.isSmooth;
    }

    public final void setSmooth(boolean bl) {
        this.isSmooth = bl;
    }

    protected abstract Control createFirstControl(Composite var1);

    protected abstract Control createSecondControl(Composite var1);

    public final Control getFirstControl() {
        return this.firstControl;
    }

    public final Control getSecondControl() {
        return this.secondControl;
    }
}

