/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.util.gui;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Control;

public final class FormDataFactory {
    private static FormDataFactory instance;
    public static final int DEFAULT_MARGIN = 5;
    private FormData fd = new FormData();
    private int margin = 5;
    private int minWidth = 0;
    private int minHeight = 0;

    private FormDataFactory() {
    }

    public static FormDataFactory getInstance() {
        if (instance == null) {
            instance = new FormDataFactory();
        }
        return instance.reset();
    }

    public FormDataFactory applyTo(Control control) {
        Point point = null;
        if (this.minWidth > 0 || this.minHeight > 0) {
            point = control.computeSize(-1, -1);
            if (this.minWidth > 0) {
                this.fd.width = Math.max(this.minWidth, point.x);
            }
            if (this.minHeight > 0) {
                this.fd.height = Math.max(this.minHeight, point.y);
            }
        }
        control.setLayoutData((Object)this.fd);
        FormData formData = this.fd;
        this.fd = new FormData();
        this.fd.width = formData.width;
        this.fd.height = formData.height;
        this.fd.top = formData.top;
        this.fd.bottom = formData.bottom;
        this.fd.left = formData.left;
        this.fd.right = formData.right;
        return this;
    }

    public FormData create() {
        FormData formData = new FormData();
        formData.width = this.fd.width;
        formData.height = this.fd.height;
        formData.top = this.fd.top;
        formData.bottom = this.fd.bottom;
        formData.left = this.fd.left;
        formData.right = this.fd.right;
        return formData;
    }

    public FormDataFactory reset() {
        this.fd = new FormData();
        this.margin = 5;
        this.minWidth = 0;
        this.minHeight = 0;
        return this;
    }

    public FormDataFactory margin(int n) {
        this.margin = n;
        return this;
    }

    public int getMargin() {
        return this.margin;
    }

    public FormDataFactory top(int n, int n2) {
        this.fd.top = new FormAttachment(n, n2);
        return this;
    }

    public FormDataFactory top() {
        this.fd.top = new FormAttachment(0, this.margin);
        return this;
    }

    public FormDataFactory untop() {
        this.fd.top = null;
        return this;
    }

    public FormDataFactory bottom(int n, int n2) {
        this.fd.bottom = new FormAttachment(n, n2);
        return this;
    }

    public FormDataFactory bottom() {
        this.fd.bottom = new FormAttachment(100, -this.margin);
        return this;
    }

    public FormDataFactory unbottom() {
        this.fd.bottom = null;
        return this;
    }

    public FormDataFactory left(int n, int n2) {
        this.fd.left = new FormAttachment(n, n2);
        return this;
    }

    public FormDataFactory left() {
        this.fd.left = new FormAttachment(0, this.margin);
        return this;
    }

    public FormDataFactory unleft() {
        this.fd.left = null;
        return this;
    }

    public FormDataFactory right(int n, int n2) {
        this.fd.right = new FormAttachment(n, n2);
        return this;
    }

    public FormDataFactory right() {
        this.fd.right = new FormAttachment(100, -this.margin);
        return this;
    }

    public FormDataFactory unright() {
        this.fd.right = null;
        return this;
    }

    public FormDataFactory top(Control control, int n) {
        this.fd.top = new FormAttachment(control, n);
        return this;
    }

    public FormDataFactory top(Control control) {
        this.fd.top = new FormAttachment(control, this.margin);
        return this;
    }

    public FormDataFactory bottom(Control control, int n) {
        this.fd.bottom = new FormAttachment(control, n);
        return this;
    }

    public FormDataFactory bottom(Control control) {
        this.fd.bottom = new FormAttachment(control, -this.margin);
        return this;
    }

    public FormDataFactory left(Control control, int n) {
        this.fd.left = new FormAttachment(control, n);
        return this;
    }

    public FormDataFactory left(Control control) {
        this.fd.left = new FormAttachment(control, this.margin);
        return this;
    }

    public FormDataFactory right(Control control, int n) {
        this.fd.right = new FormAttachment(control, n);
        return this;
    }

    public FormDataFactory right(Control control) {
        this.fd.right = new FormAttachment(control, -this.margin);
        return this;
    }

    public FormDataFactory width(int n) {
        this.fd.width = n;
        return this;
    }

    public FormDataFactory unwidth() {
        this.fd.width = -1;
        return this;
    }

    public FormDataFactory height(int n) {
        this.fd.height = n;
        return this;
    }

    public FormDataFactory unheight() {
        this.fd.height = -1;
        return this;
    }

    public FormDataFactory minWidth(int n) {
        this.minWidth = n;
        return this;
    }

    public FormDataFactory minHeight(int n) {
        this.minHeight = n;
        return this;
    }
}

