/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.util.gui;

import net.sourceforge.docfetcher.util.UtilGui;
import org.eclipse.swt.widgets.Display;

public final class StatusManager {
    private Display display;
    private StatusWidgetProvider statusLine;
    private volatile Thread thread;

    public StatusManager(Display display, StatusWidgetProvider statusWidgetProvider) {
        this.display = display;
        this.statusLine = statusWidgetProvider;
    }

    public void setStatus(final String string, final int n) {
        boolean bl;
        if (this.thread != null) {
            this.thread.interrupt();
        }
        if (!(bl = UtilGui.runSyncExec(this.display, new Runnable(){

            @Override
            public void run() {
                StatusManager.this.statusLine.setStatus(string);
            }
        }))) {
            return;
        }
        if (n <= 0) {
            return;
        }
        this.thread = new Thread(StatusManager.class.getName() + " (clear status)"){

            @Override
            public void run() {
                try {
                    Thread.sleep(n);
                    UtilGui.runSyncExec(StatusManager.this.display, new Runnable(){

                        @Override
                        public void run() {
                            String string = StatusManager.this.statusLine.getStatus();
                            if (string.equals(string)) {
                                StatusManager.this.statusLine.setStatus("");
                            }
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                StatusManager.this.thread = null;
            }
        };
        this.thread.start();
    }

    public static interface StatusWidgetProvider {
        public String getStatus();

        public void setStatus(String var1);
    }
}

