/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.util.gui;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.docfetcher.util.Util;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public final class SystemFont {
    private final List<Control> controls = new ArrayList<Control>();
    private Font font;

    public SystemFont(final Widget widget, final int n, final int n2) {
        Util.checkNotNull(widget);
        this.font = SystemFont.getSystemFont(widget, n, n2);
        widget.getDisplay().addListener(39, new Listener(){

            public void handleEvent(Event event) {
                Font font = SystemFont.getSystemFont(widget, n, n2);
                for (Control control : SystemFont.this.controls) {
                    control.setFont(font);
                }
                SystemFont.this.font.dispose();
                SystemFont.this.font = font;
            }
        });
        widget.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                SystemFont.this.font.dispose();
            }
        });
    }

    private static Font getSystemFont(Widget widget, int n, int n2) {
        Display display = widget.getDisplay();
        FontData fontData = display.getSystemFont().getFontData()[0];
        if (n > 0) {
            fontData.setHeight(n);
        }
        fontData.setStyle(n2);
        return new Font((Device)display, fontData);
    }

    public void applyTo(final Control control) {
        Util.checkNotNull(control);
        if (this.controls.contains(control)) {
            return;
        }
        this.controls.add(control);
        control.setFont(this.font);
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                SystemFont.this.controls.remove(control);
            }
        });
    }
}

