/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.util.gui;

import net.sourceforge.docfetcher.util.UtilGui;
import net.sourceforge.docfetcher.util.gui.Col;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolderRenderer;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public final class TabFolderFactory {
    private TabFolderFactory() {
    }

    public static CTabFolder create(Composite composite, boolean bl, boolean bl2, boolean bl3) {
        CTabFolder cTabFolder;
        int n = 2048;
        if (bl) {
            n |= 0x40;
        }
        if (bl2) {
            cTabFolder = new CTabFolder(composite, n);
            cTabFolder.setSimple(false);
            if (bl3) {
                TabFolderFactory.setTabColors(cTabFolder);
                cTabFolder.addListener(39, new Listener(){

                    public void handleEvent(Event event) {
                        TabFolderFactory.setTabColors(cTabFolder);
                    }
                });
            }
        } else {
            cTabFolder = new CTabFolder(composite, n);
            cTabFolder.setRenderer((CTabFolderRenderer)new CustomRenderer(cTabFolder, bl3));
        }
        return cTabFolder;
    }

    private static void setTabColors(CTabFolder cTabFolder) {
        Color color = Col.TITLE_BACKGROUND.get();
        Color color2 = UtilGui.getTextForeground(color);
        cTabFolder.setSelectionBackground(color);
        cTabFolder.setSelectionForeground(color2);
    }

    private static class CustomRenderer
    extends CTabFolderRenderer {
        private final CTabFolder tabFolder;
        private final boolean coloredTabs;

        public CustomRenderer(CTabFolder cTabFolder, boolean bl) {
            super(cTabFolder);
            this.tabFolder = cTabFolder;
            this.coloredTabs = bl;
        }

        protected void draw(int n, int n2, Rectangle rectangle, GC gC) {
            int n3;
            Object object;
            Color color;
            boolean bl = UtilGui.contains(n2, 32);
            boolean bl2 = UtilGui.contains(n2, 2);
            Color color2 = this.coloredTabs ? Col.TITLE_BACKGROUND.get() : Col.WIDGET_NORMAL_SHADOW.get();
            Color color3 = null;
            color3 = bl || bl2 ? (this.coloredTabs ? Col.TITLE_BACKGROUND.get() : Col.WIDGET_HIGHLIGHT_SHADOW.get()) : Col.WIDGET_BACKGROUND.get();
            Color color4 = Col.WIDGET_DARK_SHADOW.get();
            Color color5 = color = this.coloredTabs && (bl2 || bl) ? UtilGui.getTextForeground(Col.TITLE_BACKGROUND.get()) : Col.WIDGET_FOREGROUND.get();
            if (UtilGui.contains(n, -2)) {
                int n4 = this.tabFolder.getTabHeight();
                gC.setForeground(color2);
                gC.drawLine(rectangle.x, rectangle.y + n4 + 1, rectangle.x + rectangle.width, rectangle.y + n4 + 1);
                return;
            }
            if (n < 0) {
                super.draw(n, n2, rectangle, gC);
                return;
            }
            CTabItem cTabItem = this.tabFolder.getItem(n);
            int n5 = 2;
            int n6 = 2;
            int n7 = bl ? -1 : 0;
            gC.setAntialias(1);
            Rectangle rectangle2 = new Rectangle(rectangle.x + n5, rectangle.y + n5 + n6, rectangle.width - n5 * 2, rectangle.height - n5 * 2 - 1);
            Rectangle rectangle3 = new Rectangle(rectangle.x + n5 + n7, rectangle.y + n5 + n7 + n6, rectangle.width - n5 * 2, rectangle.height - n5 * 2 + n7);
            if (bl) {
                gC.setForeground(color4);
                gC.drawRectangle(rectangle2);
            }
            gC.setBackground(color3);
            gC.fillRectangle(rectangle3);
            gC.setForeground(color2);
            if (bl) {
                gC.drawRectangle(rectangle3);
            } else {
                gC.drawPolyline(new int[]{rectangle3.x, rectangle3.y + rectangle3.height, rectangle3.x, rectangle3.y, rectangle3.x + rectangle3.width, rectangle3.y, rectangle3.x + rectangle3.width, rectangle3.y + rectangle3.height});
            }
            Image image = cTabItem.getImage();
            int n8 = 2;
            if (image != null) {
                object = image.getBounds();
                int n9 = 6;
                n3 = (rectangle.height - object.height) / 2;
                gC.drawImage(image, rectangle.x + n9 + n7, rectangle.y + n3 + n7 + n6);
                n8 = n9 + object.width;
            }
            object = cTabItem.getText();
            Point point = gC.textExtent((String)object);
            gC.setForeground(color);
            gC.drawString((String)object, rectangle.x + n8 + n5 + n7, rectangle.y + (rectangle.height - point.y) / 2 + n7 + n6, true);
            if (bl && cTabItem.getShowClose()) {
                n3 = rectangle.x + rectangle.width - 20;
                int n10 = (rectangle.height - 9) / 2 + 1;
                int[] nArray = new int[]{n3, n10, n3 + 2, n10, n3 + 4, n10 + 2, n3 + 5, n10 + 2, n3 + 7, n10, n3 + 9, n10, n3 + 9, n10 + 2, n3 + 7, n10 + 4, n3 + 7, n10 + 5, n3 + 9, n10 + 7, n3 + 9, n10 + 9, n3 + 7, n10 + 9, n3 + 5, n10 + 7, n3 + 4, n10 + 7, n3 + 2, n10 + 9, n3, n10 + 9, n3, n10 + 7, n3 + 2, n10 + 5, n3 + 2, n10 + 4, n3, n10 + 2};
                gC.setBackground(Col.WHITE.get());
                gC.fillPolygon(nArray);
                gC.setForeground(Col.BLACK.get());
                gC.drawPolygon(nArray);
            }
        }
    }
}

