/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.util.gui;

import net.sourceforge.docfetcher.util.Util;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public final class ToolItemFactory {
    private ToolBar toolBar;
    private int style = 8;
    private Image image;
    private String text;
    private String toolTip;
    private SelectionListener selectionListener;
    private boolean enabled = true;

    public ToolItemFactory(ToolBar toolBar) {
        Util.checkNotNull(toolBar);
        this.toolBar = toolBar;
    }

    public ToolItemFactory toolBar(ToolBar toolBar) {
        Util.checkNotNull(toolBar);
        this.toolBar = toolBar;
        return this;
    }

    public ToolItem create() {
        ToolItem toolItem = new ToolItem(this.toolBar, this.style);
        if (!this.enabled) {
            toolItem.setEnabled(false);
        }
        if (this.image != null) {
            toolItem.setImage(this.image);
        }
        if (this.text != null) {
            toolItem.setText(this.text);
        }
        if (this.toolTip != null) {
            toolItem.setToolTipText(this.toolTip);
        }
        if (this.selectionListener != null) {
            toolItem.addSelectionListener(this.selectionListener);
        }
        return toolItem;
    }

    public ToolItemFactory style(int n) {
        this.style = n;
        return this;
    }

    public ToolItemFactory image(Image image) {
        this.image = image;
        return this;
    }

    public ToolItemFactory text(String string) {
        this.text = string;
        return this;
    }

    public ToolItemFactory toolTip(String string) {
        this.toolTip = string;
        return this;
    }

    public ToolItemFactory listener(SelectionListener selectionListener) {
        this.selectionListener = selectionListener;
        return this;
    }

    public ToolItemFactory enabled(boolean bl) {
        this.enabled = bl;
        return this;
    }
}

