/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.util.gui.dialog;

import net.sourceforge.docfetcher.util.AppUtil;
import net.sourceforge.docfetcher.util.Util;
import net.sourceforge.docfetcher.util.UtilGui;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;

public class InfoDialog {
    private final Shell shell;
    private final Label icon;
    private final Link label;
    private final Button bt;

    public static void main(String[] stringArray) {
        Display display = new Display();
        final Shell shell = new Shell(display);
        FillLayout fillLayout = new FillLayout();
        fillLayout.marginHeight = 5;
        fillLayout.marginWidth = 5;
        shell.setLayout((Layout)fillLayout);
        Button button = new Button((Composite)shell, 8);
        button.setText("Open Dialog");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                InfoDialog infoDialog = new InfoDialog(shell);
                infoDialog.setTitle("Title");
                infoDialog.setText("You can click this <a href=\"https://www.google.com\">link</a>.");
                infoDialog.open();
            }
        });
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                UtilGui.setCenteredBounds(shell, 200, 150);
            }
        });
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    public InfoDialog(Shell shell) {
        Util.checkNotNull(shell);
        this.shell = new Shell(shell, 34912);
        this.icon = new Label((Composite)this.shell, 0);
        this.icon.setImage(this.shell.getDisplay().getSystemImage(2));
        this.label = new Link((Composite)this.shell, 0);
        this.label.setBackground(this.icon.getBackground());
        this.label.setForeground(this.icon.getForeground());
        this.label.addSelectionListener((SelectionListener)new SelectionAdapter(this){

            public void widgetSelected(SelectionEvent selectionEvent) {
                UtilGui.launch(selectionEvent.text);
            }
        });
        this.bt = new Button((Composite)this.shell, 8);
        this.bt.setText(AppUtil.Messages.ok.get());
        this.bt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                InfoDialog.this.shell.close();
            }
        });
        this.shell.setLayout((Layout)UtilGui.createGridLayout(2, false, 10, 15));
        this.icon.setLayoutData((Object)new GridData(4, 128, false, false));
        GridData gridData = new GridData(4, 4, true, true);
        gridData.widthHint = 300;
        this.label.setLayoutData((Object)gridData);
        GridData gridData2 = new GridData(0x1000000, 4, true, false, 2, 1);
        gridData2.minimumWidth = 75;
        this.bt.setLayoutData((Object)gridData2);
    }

    public void setTitle(String string) {
        Util.checkNotNull(string);
        this.shell.setText(string);
    }

    public void setImage(Image image) {
        Util.checkNotNull(image);
        this.icon.setImage(image);
    }

    public void setImage(int n) {
        this.icon.setImage(this.shell.getDisplay().getSystemImage(n));
    }

    public void setText(String string) {
        Util.checkNotNull(string);
        this.label.setText(string);
    }

    public void open() {
        UtilGui.setCenteredBounds(this.shell);
        this.bt.setFocus();
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
    }
}

