/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.util.gui.viewer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.sourceforge.docfetcher.util.Event;
import net.sourceforge.docfetcher.util.Util;
import net.sourceforge.docfetcher.util.UtilGui;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public abstract class PagedTableViewer<E> {
    private Object rootElement;
    private final Table table;
    private final Map<E, TableItem> elementToItemMap = Maps.newHashMap();
    private ElementInfo<E> elementInfo;
    private final List<Column<E>> columns = Lists.newArrayList();
    private int elementsPerPage = Integer.MAX_VALUE;
    private int pageIndex = 0;
    private final List<List<E>> emptyPages = Collections.singletonList(Collections.emptyList());
    private List<List<E>> pages = this.emptyPages;

    public PagedTableViewer(Composite composite, int n) {
        if (UtilGui.contains(n, 0x10000000)) {
            throw new IllegalArgumentException("This class does not support virtual tables.");
        }
        this.table = new Table(composite, n);
        this.table.setHeaderVisible(true);
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                TableItem tableItem = PagedTableViewer.this.table.getItem(new Point(mouseEvent.x, mouseEvent.y));
                if (tableItem == null) {
                    return;
                }
                PagedTableViewer.this.onDoubleClick(tableItem.getData());
            }
        });
    }

    public final Table getControl() {
        return this.table;
    }

    public final void setElementInfo(ElementInfo<E> elementInfo) {
        this.elementInfo = elementInfo;
    }

    public final void addColumn(Column<E> column) {
        Util.checkNotNull(column);
        this.columns.add(column);
        final TableColumn tableColumn = new TableColumn(this.table, column.orientation);
        tableColumn.setText(column.label);
        tableColumn.setToolTipText(column.getToolTipText());
        column.evtLabelChanged.add(new Event.Listener<String>(this){

            @Override
            public void update(String string) {
                tableColumn.setText(string);
            }
        });
    }

    public final List<Column<E>> getColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    public final void setRoot(Object object) {
        this.rootElement = object;
        this.table.removeAll();
        this.elementToItemMap.clear();
        this.pages = this.emptyPages;
        if (this.columns.isEmpty()) {
            return;
        }
        Collection<E> collection = this.getElements(object);
        this.pages = collection == null || collection.isEmpty() ? this.emptyPages : (this.elementsPerPage == Integer.MAX_VALUE ? Collections.singletonList(this.filterAndSort(collection)) : Lists.partition(this.filterAndSort(collection), (int)this.elementsPerPage));
        assert (this.pageIndex >= 0);
        assert (this.pages.size() >= 1);
        this.pageIndex = Util.clamp(this.pageIndex, 0, this.pages.size() - 1);
        List<E> list = this.pages.get(this.pageIndex);
        this.onPageRefresh(list);
        for (E e : list) {
            TableItem tableItem = new TableItem(this.table, 0);
            this.update(e, tableItem);
            this.elementToItemMap.put(e, tableItem);
        }
    }

    public final Object getRoot() {
        return this.rootElement;
    }

    public final void refresh() {
        this.setRoot(this.rootElement);
    }

    private void update(E e, TableItem tableItem) {
        int n = this.columns.size();
        if (n == 0) {
            return;
        }
        if (this.elementInfo != null) {
            tableItem.setChecked(this.elementInfo.isChecked(e));
        }
        for (int i = 0; i < n; ++i) {
            Column<E> column = this.columns.get(i);
            tableItem.setText(i, column.getLabel(e));
            tableItem.setImage(i, column.getImage(e));
            tableItem.setForeground(i, column.getForeground(e));
            tableItem.setBackground(i, column.getBackground(e));
        }
        tableItem.setData(e);
    }

    private List<E> filterAndSort(Collection<E> collection) {
        ArrayList<E> arrayList = new ArrayList<E>(collection.size());
        for (E e : collection) {
            if (!this.filter(e)) continue;
            arrayList.add(e);
        }
        this.sort(arrayList);
        return arrayList;
    }

    protected abstract Collection<E> getElements(Object var1);

    protected void sort(List<E> list) {
    }

    protected boolean filter(E e) {
        return true;
    }

    protected void onDoubleClick(E e) {
    }

    protected void onPageRefresh(List<E> list) {
    }

    protected void onSelectionChanged(E e) {
    }

    public final List<E> getChecked() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (TableItem tableItem : this.table.getItems()) {
            if (!tableItem.getChecked()) continue;
            arrayList.add(tableItem.getData());
        }
        return arrayList;
    }

    public final List<E> getSelection() {
        TableItem[] tableItemArray = this.table.getSelection();
        ArrayList<Object> arrayList = new ArrayList<Object>(tableItemArray.length);
        for (TableItem tableItem : tableItemArray) {
            arrayList.add(tableItem.getData());
        }
        return arrayList;
    }

    public final int getSelectionCount() {
        return this.table.getSelectionCount();
    }

    public final void update(E e) {
        if (e == null) {
            return;
        }
        this.update(e, this.elementToItemMap.get(e));
    }

    public final void update() {
        for (Map.Entry<E, TableItem> entry : this.elementToItemMap.entrySet()) {
            this.update(entry.getKey(), entry.getValue());
        }
    }

    public final void showElement(E e) {
        if (e == null) {
            return;
        }
        TableItem tableItem = this.elementToItemMap.get(e);
        if (tableItem != null) {
            this.table.showItem(tableItem);
            this.table.setSelection(tableItem);
            return;
        }
        for (int i = 0; i < this.pages.size(); ++i) {
            for (E e2 : this.pages.get(i)) {
                if (e2 != e) continue;
                this.pageIndex = i;
                this.refresh();
                TableItem tableItem2 = this.elementToItemMap.get(e);
                this.table.showItem(tableItem2);
                this.table.setSelection(tableItem2);
                return;
            }
        }
    }

    public final List<E> getElements(int n) {
        Util.checkThat(n >= 0);
        Util.checkThat(n < this.pages.size());
        return Collections.unmodifiableList(this.pages.get(n));
    }

    public final boolean setFocus() {
        return this.table.setFocus();
    }

    public final int getElementsPerPage() {
        assert (this.elementsPerPage >= 1);
        return this.elementsPerPage;
    }

    public final void setElementsPerPage(int n) {
        int n2 = this.elementsPerPage;
        this.elementsPerPage = Math.max(1, n);
        if (n2 != this.elementsPerPage) {
            this.pageIndex = 0;
            this.refresh();
        }
    }

    public final int getPageCount() {
        return this.pages.size();
    }

    public final int getPageIndex() {
        assert (this.pageIndex >= 0 && this.pageIndex < this.pages.size());
        return this.pageIndex;
    }

    public final void setPage(int n) {
        int n2 = this.pageIndex;
        this.pageIndex = Util.clamp(n, 0, this.pages.size() - 1);
        if (n2 != this.pageIndex) {
            this.refresh();
        }
    }

    public final void previousPage() {
        this.setPage(--this.pageIndex);
    }

    public final void nextPage() {
        this.setPage(++this.pageIndex);
    }

    public static abstract class ElementInfo<E> {
        protected boolean isChecked(E e) {
            return true;
        }
    }

    public static abstract class Column<E> {
        private String label;
        private final int orientation;
        private final Event<String> evtLabelChanged = new Event();

        public Column(String string) {
            this(string, 16384);
        }

        public Column(String string, int n) {
            this.label = Util.checkNotNull(string);
            this.orientation = n;
        }

        public final void setLabel(String string) {
            Util.checkNotNull(string);
            if (this.label.equals(string)) {
                return;
            }
            this.label = string;
            this.evtLabelChanged.fire(string);
        }

        protected String getToolTipText() {
            return null;
        }

        protected abstract String getLabel(E var1);

        protected Image getImage(E e) {
            return null;
        }

        protected Color getForeground(E e) {
            return null;
        }

        protected Color getBackground(E e) {
            return null;
        }
    }
}

