/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.util.gui.viewer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.sourceforge.docfetcher.util.Event;
import net.sourceforge.docfetcher.util.Util;
import net.sourceforge.docfetcher.util.UtilGui;
import net.sourceforge.docfetcher.util.collect.ListMap;
import net.sourceforge.docfetcher.util.gui.viewer.ColumnEditSupport;
import net.sourceforge.docfetcher.util.gui.viewer.TableEditSupport;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public final class SimpleTableViewer<E> {
    private final Table table;
    private final List<Column<E>> columns = new ArrayList<Column<E>>();
    private final ListMap<E, TableItem> elementToItemMap = ListMap.create();
    private final ItemDisposeListener itemDisposeListener = new ItemDisposeListener();
    private TableEditSupport<E> editSupport;

    public SimpleTableViewer(Composite composite, int n) {
        Util.checkThat(!UtilGui.contains(n, 0x10000000));
        this.table = new Table(composite, n);
        this.table.setHeaderVisible(true);
    }

    public Table getControl() {
        return this.table;
    }

    public void addColumn(Column<E> column) {
        Util.checkNotNull(column);
        this.columns.add(column);
        final TableColumn tableColumn = new TableColumn(this.table, column.orientation);
        tableColumn.setText(column.label);
        tableColumn.setToolTipText(column.getToolTipText());
        column.evtLabelChanged.add(new Event.Listener<String>(this){

            @Override
            public void update(String string) {
                tableColumn.setText(string);
            }
        });
    }

    public List<Column<E>> getColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    public void add(E e) {
        if (this.elementToItemMap.containsKey(e)) {
            return;
        }
        TableItem tableItem = new TableItem(this.table, 0);
        this.updateItem(e, tableItem);
        tableItem.addDisposeListener((DisposeListener)this.itemDisposeListener);
        this.elementToItemMap.add(e, tableItem);
    }

    public void remove(E e) {
        Util.checkNotNull(e);
        if (this.editSupport != null) {
            this.editSupport.cancelEditing();
        }
        this.elementToItemMap.getValue(e).dispose();
    }

    public void removeAll() {
        if (this.editSupport != null) {
            this.editSupport.cancelEditing();
        }
        this.table.removeAll();
    }

    public void update(E e) {
        this.updateItem(e, this.elementToItemMap.getValue(e));
    }

    private void updateItem(E e, TableItem tableItem) {
        for (int i = 0; i < this.columns.size(); ++i) {
            Column<E> column = this.columns.get(i);
            tableItem.setText(i, column.getLabel(e));
            tableItem.setImage(i, column.getImage(e));
            tableItem.setForeground(i, column.getForeground(e));
            tableItem.setBackground(i, column.getBackground(e));
        }
        tableItem.setData(e);
    }

    public void move(E e, boolean bl) {
        Util.checkNotNull(e);
        TableItem tableItem = this.elementToItemMap.getValue(e);
        int n = this.table.indexOf(tableItem);
        assert (n >= 0);
        if (n == 0 && bl) {
            return;
        }
        if (n == this.table.getItemCount() - 1 && !bl) {
            return;
        }
        if (this.editSupport != null) {
            this.editSupport.cancelEditing();
        }
        int n2 = n + (bl ? -1 : 1);
        TableItem tableItem2 = this.table.getItem(n2);
        Object object = tableItem2.getData();
        this.updateItem(e, tableItem2);
        this.updateItem(object, tableItem);
        this.elementToItemMap.replaceKey(e, tableItem2);
        this.elementToItemMap.replaceKey(object, tableItem);
        List<TableItem> list = Arrays.asList(this.table.getSelection());
        if (!list.isEmpty()) {
            boolean bl2 = list.contains(tableItem);
            boolean bl3 = list.contains(tableItem2);
            if (bl2) {
                this.table.select(n2);
            } else {
                this.table.deselect(n2);
            }
            if (bl3) {
                this.table.select(n);
            } else {
                this.table.deselect(n);
            }
        }
    }

    public int getItemCount() {
        return this.elementToItemMap.size();
    }

    public void showElement(E e) {
        Util.checkThat(!this.elementToItemMap.isEmpty());
        TableItem tableItem = this.elementToItemMap.getValue(e);
        this.table.showItem(tableItem);
    }

    public List<E> getSelection() {
        TableItem[] tableItemArray = this.table.getSelection();
        ArrayList<Object> arrayList = new ArrayList<Object>(tableItemArray.length);
        for (TableItem tableItem : tableItemArray) {
            arrayList.add(tableItem.getData());
        }
        return arrayList;
    }

    public void setSelection(E e) {
        Util.checkNotNull(e);
        TableItem tableItem = this.elementToItemMap.getValue(e);
        Util.checkNotNull(tableItem);
        this.table.setSelection(tableItem);
    }

    public void setSelection(Collection<E> collection) {
        Util.checkNotNull(collection);
        TableItem[] tableItemArray = new TableItem[collection.size()];
        int n = 0;
        for (E e : collection) {
            TableItem tableItem = this.elementToItemMap.getValue(e);
            Util.checkNotNull(tableItem);
            tableItemArray[n] = tableItem;
            ++n;
        }
        this.table.setSelection(tableItemArray);
    }

    public List<E> getElements() {
        return this.elementToItemMap.getKeys();
    }

    public void enableEditSupport() {
        if (this.editSupport != null) {
            return;
        }
        this.editSupport = new TableEditSupport<E>(this.table){

            @Override
            protected ColumnEditSupport<E> getColumnEditSupport(int n) {
                return SimpleTableViewer.this.columns.get(n).getEditSupport();
            }
        };
    }

    private final class ItemDisposeListener
    implements DisposeListener {
        private ItemDisposeListener() {
        }

        public void widgetDisposed(DisposeEvent disposeEvent) {
            TableItem tableItem = (TableItem)disposeEvent.widget;
            SimpleTableViewer.this.elementToItemMap.removeValue(tableItem);
        }
    }

    public static abstract class Column<E> {
        private String label;
        private final int orientation;
        private final Event<String> evtLabelChanged = new Event();

        public Column(String string) {
            this(string, 16384);
        }

        public Column(String string, int n) {
            this.label = Util.checkNotNull(string);
            this.orientation = n;
        }

        public final void setLabel(String string) {
            Util.checkNotNull(string);
            if (this.label.equals(string)) {
                return;
            }
            this.label = string;
            this.evtLabelChanged.fire(string);
        }

        protected abstract String getLabel(E var1);

        protected String getToolTipText() {
            return null;
        }

        protected Image getImage(E e) {
            return null;
        }

        protected Color getForeground(E e) {
            return null;
        }

        protected Color getBackground(E e) {
            return null;
        }

        protected ColumnEditSupport<E> getEditSupport() {
            return null;
        }
    }
}

