/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.util.gui.viewer;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sourceforge.docfetcher.util.Util;
import net.sourceforge.docfetcher.util.UtilGui;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public abstract class SimpleTreeViewer<E> {
    private final List<E> rootElements = new ArrayList();
    private final Tree tree;
    private final Map<E, TreeItem> elementToItemMap = Maps.newHashMap();
    private final ItemDisposeListener itemDisposeListener = new ItemDisposeListener();

    public SimpleTreeViewer(Composite composite, int n) {
        this(new Tree(composite, n));
    }

    public SimpleTreeViewer(Tree tree) {
        this.tree = Util.checkNotNull(tree);
        tree.addTreeListener(new TreeListener(){

            public void treeExpanded(TreeEvent treeEvent) {
                SimpleTreeViewer.this.loadNextButOneLevel((TreeItem)treeEvent.item);
            }

            public void treeCollapsed(TreeEvent treeEvent) {
                SimpleTreeViewer.this.disposeNextButOneLevel((TreeItem)treeEvent.item);
            }
        });
        tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                TreeItem treeItem = (TreeItem)selectionEvent.item;
                if (treeItem.getExpanded()) {
                    treeItem.setExpanded(false);
                    SimpleTreeViewer.this.disposeNextButOneLevel(treeItem);
                } else {
                    SimpleTreeViewer.this.loadNextButOneLevel(treeItem);
                    treeItem.setExpanded(true);
                }
            }
        });
        if (UtilGui.contains(tree.getStyle(), 32)) {
            tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    if (!UtilGui.contains(selectionEvent.detail, 32)) {
                        return;
                    }
                    TreeItem treeItem = (TreeItem)selectionEvent.item;
                    Object object = treeItem.getData();
                    SimpleTreeViewer.this.setChecked(object, treeItem.getChecked());
                }
            });
        }
    }

    private void loadNextButOneLevel(TreeItem treeItem) {
        E e = this.getElement(treeItem);
        for (E e2 : this.getFilteredChildren(e)) {
            TreeItem treeItem2 = this.elementToItemMap.get(e2);
            if (treeItem2 == null) continue;
            this.createChildItems(treeItem2, e2);
        }
    }

    private void disposeNextButOneLevel(TreeItem treeItem) {
        for (TreeItem treeItem2 : treeItem.getItems()) {
            treeItem2.removeAll();
        }
    }

    public final Tree getControl() {
        return this.tree;
    }

    private E getElement(TreeItem treeItem) {
        return (E)treeItem.getData();
    }

    public final void setRoots(Iterable<E> iterable) {
        Util.checkNotNull(iterable);
        this.tree.removeAll();
        this.elementToItemMap.clear();
        this.rootElements.clear();
        this.rootElements.addAll(this.filterAndSort(iterable));
        for (E e : this.rootElements) {
            this.createRootItemWithChildren(e, -1);
        }
    }

    public final Iterable<E> getRoots() {
        return this.rootElements;
    }

    private void createRootItemWithChildren(E e, int n) {
        TreeItem treeItem = n < 0 ? new TreeItem(this.tree, 0) : new TreeItem(this.tree, 0, n);
        this.update(e, treeItem);
        treeItem.addDisposeListener((DisposeListener)this.itemDisposeListener);
        this.elementToItemMap.put(e, treeItem);
        this.createChildItems(treeItem, e);
    }

    private TreeItem createItem(TreeItem treeItem, E e, int n) {
        TreeItem treeItem2 = n < 0 ? new TreeItem(treeItem, 0) : new TreeItem(treeItem, 0, n);
        this.update(e, treeItem2);
        treeItem2.addDisposeListener((DisposeListener)this.itemDisposeListener);
        this.elementToItemMap.put(e, treeItem2);
        return treeItem2;
    }

    private void createChildItems(TreeItem treeItem, E e) {
        for (E e2 : this.getFilteredChildren(e)) {
            this.createItem(treeItem, e2, -1);
        }
    }

    private void update(E e, TreeItem treeItem) {
        if (treeItem == null) {
            return;
        }
        treeItem.setImage(this.getImage(e));
        treeItem.setText(this.getLabel(e));
        if (UtilGui.contains(this.tree.getStyle(), 32)) {
            treeItem.setChecked(this.isChecked(e));
        }
        treeItem.setForeground(this.getForeground(e));
        treeItem.setBackground(this.getBackground(e));
        treeItem.setData(e);
    }

    private List<E> filterAndSort(Iterable<E> iterable) {
        ArrayList<E> arrayList;
        if (iterable == null) {
            return new ArrayList(0);
        }
        Iterator<E> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            return new ArrayList(0);
        }
        if (iterable instanceof Collection) {
            int n = ((Collection)iterable).size();
            arrayList = new ArrayList(n);
        } else {
            arrayList = new ArrayList<E>();
        }
        do {
            E e;
            if (!this.filter(e = iterator.next())) continue;
            arrayList.add(e);
        } while (iterator.hasNext());
        this.sort(arrayList);
        return arrayList;
    }

    private List<E> getFilteredChildren(E e) {
        return this.filterAndSort(this.getChildren(e));
    }

    protected abstract Iterable<E> getChildren(E var1);

    protected abstract String getLabel(E var1);

    protected boolean isChecked(E e) {
        throw new UnsupportedOperationException();
    }

    protected void setChecked(E e, boolean bl) {
        throw new UnsupportedOperationException();
    }

    protected Image getImage(E e) {
        return null;
    }

    protected Color getForeground(E e) {
        return null;
    }

    protected Color getBackground(E e) {
        return null;
    }

    protected void sort(List<E> list) {
    }

    protected boolean filter(E e) {
        return true;
    }

    public final List<E> getSelection() {
        TreeItem[] treeItemArray = this.tree.getSelection();
        ArrayList<E> arrayList = new ArrayList<E>(treeItemArray.length);
        for (TreeItem treeItem : treeItemArray) {
            arrayList.add(this.getElement(treeItem));
        }
        return arrayList;
    }

    @SafeVarargs
    public final void setSelection(E ... EArray) {
        Util.checkNotNull(EArray);
        TreeItem[] treeItemArray = new TreeItem[EArray.length];
        for (int i = 0; i < EArray.length; ++i) {
            treeItemArray[i] = this.elementToItemMap.get(EArray[i]);
        }
        this.tree.setSelection(treeItemArray);
    }

    public final int getSelectionCount() {
        return this.tree.getSelectionCount();
    }

    public final void update(E e) {
        Util.checkNotNull(e);
        this.update(e, this.elementToItemMap.get(e));
    }

    public final void update() {
        for (Map.Entry<E, TreeItem> entry : this.elementToItemMap.entrySet()) {
            this.update(entry.getKey(), entry.getValue());
        }
    }

    public final void refreshChildren(E e) {
        Util.checkNotNull(e);
        TreeItem treeItem = this.elementToItemMap.get(e);
        boolean bl = treeItem.getExpanded();
        Map<E, Boolean> map = this.getExpandedStates(e);
        treeItem.removeAll();
        this.createChildItems(treeItem, e);
        if (bl) {
            for (E e2 : this.getFilteredChildren(e)) {
                this.createChildItems(this.elementToItemMap.get(e2), e2);
            }
        }
        treeItem.setExpanded(bl);
        this.setExpandedStates(e, map);
    }

    public final void refresh() {
        this.setRoots(this.rootElements);
    }

    public final void addRoot(E e) {
        Util.checkNotNull(e);
        if (!this.filter(e)) {
            return;
        }
        if (!this.rootElements.contains(e)) {
            this.rootElements.add(e);
        }
        this.sort(this.rootElements);
        int n = this.rootElements.indexOf(e);
        this.createRootItemWithChildren(e, n);
    }

    public final void add(E e, E e2) {
        ArrayList<E> arrayList;
        int n;
        Util.checkNotNull(e, e2);
        TreeItem treeItem = this.elementToItemMap.get(e);
        if (treeItem == null) {
            return;
        }
        TreeItem treeItem2 = treeItem.getParentItem();
        if (treeItem2 != null && !treeItem2.getExpanded()) {
            return;
        }
        if (!this.filter(e2)) {
            return;
        }
        if (this.elementToItemMap.get(e2) != null) {
            return;
        }
        Iterable<E> iterable = this.getChildren(e);
        if (iterable == null) {
            this.createItem(treeItem, e2, -1);
            return;
        }
        Iterator<E> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            this.createItem(treeItem, e2, -1);
            return;
        }
        if (iterable instanceof Collection) {
            n = ((Collection)iterable).size();
            arrayList = new ArrayList(n + 1);
        } else {
            arrayList = new ArrayList<E>();
        }
        n = 0;
        do {
            E e3;
            if ((e3 = iterator.next()) == e2) {
                n = 1;
            }
            if (!this.filter(e3)) continue;
            arrayList.add(e3);
        } while (iterator.hasNext());
        if (n == 0) {
            arrayList.add(e2);
        }
        this.sort(arrayList);
        int n2 = arrayList.indexOf(e2);
        try {
            this.createItem(treeItem, e2, n2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.createItem(treeItem, e2, -1);
        }
    }

    public final void remove(E e) {
        Util.checkNotNull(e);
        TreeItem treeItem = this.elementToItemMap.get(e);
        if (treeItem == null) {
            return;
        }
        treeItem.removeAll();
        treeItem.dispose();
    }

    public final void remove(Iterable<E> iterable) {
        Util.checkNotNull(iterable);
        this.tree.setRedraw(false);
        for (E e : iterable) {
            TreeItem treeItem = this.elementToItemMap.get(e);
            if (treeItem == null) continue;
            treeItem.removeAll();
            treeItem.dispose();
        }
        this.tree.setRedraw(true);
    }

    private Map<E, Boolean> getExpandedStates(E e) {
        HashMap hashMap = Maps.newHashMap();
        this.getExpandedStates(e, hashMap);
        return hashMap;
    }

    private void getExpandedStates(E e, Map<E, Boolean> map) {
        for (E e2 : this.getFilteredChildren(e)) {
            TreeItem treeItem = this.elementToItemMap.get(e2);
            if (treeItem == null) continue;
            map.put(e2, treeItem.getExpanded());
            this.getExpandedStates(e2, map);
        }
    }

    private void setExpandedStates(E e, Map<E, Boolean> map) {
        for (E e2 : this.getFilteredChildren(e)) {
            TreeItem treeItem;
            Boolean bl = map.get(e2);
            if (bl == null || (treeItem = this.elementToItemMap.get(e2)) == null) continue;
            treeItem.setExpanded(bl.booleanValue());
            this.setExpandedStates(e2, map);
        }
    }

    public final List<E> getElements() {
        return new ArrayList<E>(this.elementToItemMap.keySet());
    }

    public final void expand(E e) {
        Util.checkNotNull(e);
        TreeItem treeItem = this.elementToItemMap.get(e);
        if (treeItem.getExpanded()) {
            return;
        }
        for (E e2 : this.getFilteredChildren(e)) {
            this.createChildItems(this.elementToItemMap.get(e2), e2);
        }
        treeItem.setExpanded(true);
    }

    public final void collapse(E e) {
        Util.checkNotNull(e);
        TreeItem treeItem = this.elementToItemMap.get(e);
        if (!treeItem.getExpanded()) {
            return;
        }
        for (E e2 : this.getFilteredChildren(e)) {
            this.elementToItemMap.get(e2).removeAll();
        }
        treeItem.setExpanded(false);
    }

    public final E getElement(Point point) {
        Util.checkNotNull(point);
        TreeItem treeItem = this.tree.getItem(point);
        if (treeItem == null) {
            return null;
        }
        return this.getElement(treeItem);
    }

    public final TreeItem getItem(E e) {
        Util.checkNotNull(e);
        return this.elementToItemMap.get(e);
    }

    public final void showElement(E e) {
        Util.checkNotNull(e);
        TreeItem treeItem = this.elementToItemMap.get(e);
        this.tree.showItem(treeItem);
        this.tree.setSelection(treeItem);
    }

    public final boolean setFocus() {
        return this.tree.setFocus();
    }

    private class ItemDisposeListener
    implements DisposeListener {
        private ItemDisposeListener() {
        }

        public void widgetDisposed(DisposeEvent disposeEvent) {
            TreeItem treeItem = (TreeItem)disposeEvent.widget;
            Object e = SimpleTreeViewer.this.getElement(treeItem);
            SimpleTreeViewer.this.elementToItemMap.remove(e);
            if (treeItem.getParentItem() == null) {
                SimpleTreeViewer.this.rootElements.remove(e);
            }
        }
    }
}

