/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.util.gui.viewer;

import net.sourceforge.docfetcher.util.Util;
import net.sourceforge.docfetcher.util.UtilGui;
import net.sourceforge.docfetcher.util.gui.viewer.ColumnEditSupport;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

abstract class TableEditSupport<E> {
    private final Table table;
    private final TableEditor tableEditor;

    public TableEditSupport(final Table table) {
        Util.checkNotNull(table);
        this.table = table;
        this.tableEditor = new TableEditor(table);
        this.tableEditor.grabHorizontal = true;
        this.tableEditor.grabVertical = true;
        table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent mouseEvent) {
                Control control;
                TableEditSupport.this.cancelEditing();
                TableItem tableItem = table.getItem(new Point(mouseEvent.x, mouseEvent.y));
                if (tableItem == null) {
                    return;
                }
                int n = -1;
                for (int i = 0; i < table.getColumnCount(); ++i) {
                    if (!tableItem.getBounds(i).contains(mouseEvent.x, mouseEvent.y)) continue;
                    n = i;
                    break;
                }
                if (n == -1) {
                    return;
                }
                ColumnEditSupport columnEditSupport = TableEditSupport.this.getColumnEditSupport(n);
                if (columnEditSupport == null) {
                    return;
                }
                if (columnEditSupport instanceof ColumnEditSupport.TextEditSupport) {
                    ColumnEditSupport.TextEditSupport textEditSupport = (ColumnEditSupport.TextEditSupport)columnEditSupport;
                    control = TableEditSupport.this.createTextEditor(textEditSupport, tableItem, n);
                } else if (columnEditSupport instanceof ColumnEditSupport.ComboEditSupport) {
                    ColumnEditSupport.ComboEditSupport comboEditSupport = (ColumnEditSupport.ComboEditSupport)columnEditSupport;
                    control = TableEditSupport.this.createComboEditor(comboEditSupport, tableItem, n);
                } else {
                    throw new IllegalStateException();
                }
                TableEditSupport.this.tableEditor.setEditor(control, tableItem, n);
                control.setFocus();
            }
        });
    }

    private Control createTextEditor(final ColumnEditSupport.TextEditSupport<E> textEditSupport, final TableItem tableItem, final int n) {
        final Composite composite = new Composite((Composite)this.table, 0);
        composite.setLayout((Layout)UtilGui.createGridLayout(1, false, 0, 0));
        String string = tableItem.getText(n);
        final StyledText styledText = new StyledText(composite, 4);
        styledText.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        styledText.setText(string);
        styledText.setSelection(string.length());
        styledText.selectAll();
        final Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Object object = tableItem.getData();
                String string = styledText.getText();
                textEditSupport.setText(object, string);
                tableItem.setText(n, string);
                composite.dispose();
            }
        };
        styledText.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent traverseEvent) {
                if (traverseEvent.detail == 2) {
                    traverseEvent.doit = false;
                    composite.dispose();
                }
            }
        });
        styledText.addKeyListener((KeyListener)new KeyAdapter(this){

            public void keyPressed(KeyEvent keyEvent) {
                if (UtilGui.isEnterKey(keyEvent.keyCode)) {
                    keyEvent.doit = false;
                    runnable.run();
                }
            }
        });
        styledText.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                composite.dispose();
            }
        });
        styledText.addFocusListener((FocusListener)new FocusAdapter(this){

            public void focusLost(FocusEvent focusEvent) {
                runnable.run();
            }
        });
        return composite;
    }

    private Control createComboEditor(final ColumnEditSupport.ComboEditSupport<E, ?> comboEditSupport, final TableItem tableItem, final int n) {
        final CCombo cCombo = new CCombo((Composite)this.table, 0x800008);
        cCombo.setItems(comboEditSupport.getStringChoices());
        cCombo.setText(tableItem.getText(n));
        final Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Object object = tableItem.getData();
                String string = cCombo.getText();
                comboEditSupport.setChoice(object, string);
                tableItem.setText(n, string);
                cCombo.dispose();
            }
        };
        cCombo.addFocusListener((FocusListener)new FocusAdapter(this){

            public void focusLost(FocusEvent focusEvent) {
                runnable.run();
            }
        });
        cCombo.addSelectionListener((SelectionListener)new SelectionAdapter(this){

            public void widgetSelected(SelectionEvent selectionEvent) {
                runnable.run();
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                runnable.run();
            }
        });
        UtilGui.runAsyncExec((Widget)cCombo, new Runnable(){

            @Override
            public void run() {
                cCombo.setListVisible(true);
            }
        });
        return cCombo;
    }

    public final void cancelEditing() {
        Control control = this.tableEditor.getEditor();
        if (control != null) {
            control.dispose();
        }
    }

    protected abstract ColumnEditSupport<E> getColumnEditSupport(int var1);
}

