/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.nio.file.Path;
import java.util.Properties;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.detect.Detector;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.IOUtils;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.language.translate.Translator;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.ParsingReader;
import org.apache.tika.sax.BodyContentHandler;
import org.apache.tika.sax.WriteOutContentHandler;
import org.xml.sax.SAXException;

public class Tika {
    private final Detector detector;
    private final Parser parser;
    private final Translator translator;
    private int maxStringLength = 100000;

    public Tika(Detector detector, Parser parser) {
        this.detector = detector;
        this.parser = parser;
        this.translator = TikaConfig.getDefaultConfig().getTranslator();
    }

    public Tika(Detector detector, Parser parser, Translator translator) {
        this.detector = detector;
        this.parser = parser;
        this.translator = translator;
    }

    public Tika(TikaConfig tikaConfig) {
        this(tikaConfig.getDetector(), new AutoDetectParser(tikaConfig), tikaConfig.getTranslator());
    }

    public Tika() {
        this(TikaConfig.getDefaultConfig());
    }

    public Tika(Detector detector) {
        this(detector, new AutoDetectParser(detector));
    }

    public String detect(InputStream inputStream, Metadata metadata) throws IOException {
        if (inputStream == null || inputStream.markSupported()) {
            return this.detector.detect(inputStream, metadata).toString();
        }
        return this.detector.detect(new BufferedInputStream(inputStream), metadata).toString();
    }

    public String detect(InputStream inputStream, String string) throws IOException {
        Metadata metadata = new Metadata();
        metadata.set("resourceName", string);
        return this.detect(inputStream, metadata);
    }

    public String detect(InputStream inputStream) throws IOException {
        return this.detect(inputStream, new Metadata());
    }

    public String detect(byte[] byArray, String string) {
        String string2;
        block8: {
            TikaInputStream tikaInputStream = TikaInputStream.get(byArray);
            try {
                string2 = this.detect((InputStream)tikaInputStream, string);
                if (tikaInputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (tikaInputStream != null) {
                        try {
                            ((InputStream)tikaInputStream).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    throw new IllegalStateException("Unexpected IOException", iOException);
                }
            }
            ((InputStream)tikaInputStream).close();
        }
        return string2;
    }

    public String detect(byte[] byArray) {
        String string;
        block8: {
            TikaInputStream tikaInputStream = TikaInputStream.get(byArray);
            try {
                string = this.detect(tikaInputStream);
                if (tikaInputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (tikaInputStream != null) {
                        try {
                            ((InputStream)tikaInputStream).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    throw new IllegalStateException("Unexpected IOException", iOException);
                }
            }
            ((InputStream)tikaInputStream).close();
        }
        return string;
    }

    public String detect(Path path) throws IOException {
        Metadata metadata = new Metadata();
        try (TikaInputStream tikaInputStream = TikaInputStream.get(path, metadata);){
            String string = this.detect((InputStream)tikaInputStream, metadata);
            return string;
        }
    }

    public String detect(File file) throws IOException {
        Metadata metadata = new Metadata();
        try (TikaInputStream tikaInputStream = TikaInputStream.get(file, metadata);){
            String string = this.detect((InputStream)tikaInputStream, metadata);
            return string;
        }
    }

    public String detect(URL uRL) throws IOException {
        Metadata metadata = new Metadata();
        try (TikaInputStream tikaInputStream = TikaInputStream.get(uRL, metadata);){
            String string = this.detect((InputStream)tikaInputStream, metadata);
            return string;
        }
    }

    public String detect(String string) {
        try {
            return this.detect((InputStream)null, string);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Unexpected IOException", iOException);
        }
    }

    public String translate(String string, String string2, String string3) {
        try {
            return this.translator.translate(string, string2, string3);
        }
        catch (Exception exception) {
            throw new IllegalStateException("Error translating data.", exception);
        }
    }

    public String translate(String string, String string2) {
        try {
            return this.translator.translate(string, string2);
        }
        catch (Exception exception) {
            throw new IllegalStateException("Error translating data.", exception);
        }
    }

    public String translate(InputStream inputStream, String string, String string2) {
        try {
            return this.translator.translate(IOUtils.toString(inputStream), string, string2);
        }
        catch (Exception exception) {
            throw new IllegalStateException("Error translating data.", exception);
        }
    }

    public String translate(InputStream inputStream, String string) {
        try {
            return this.translator.translate(IOUtils.toString(inputStream), string);
        }
        catch (Exception exception) {
            throw new IllegalStateException("Error translating data.", exception);
        }
    }

    public Reader parse(InputStream inputStream, Metadata metadata) throws IOException {
        ParseContext parseContext = new ParseContext();
        parseContext.set(Parser.class, this.parser);
        return new ParsingReader(this.parser, inputStream, metadata, parseContext);
    }

    public Reader parse(InputStream inputStream) throws IOException {
        return this.parse(inputStream, new Metadata());
    }

    public Reader parse(Path path, Metadata metadata) throws IOException {
        TikaInputStream tikaInputStream = TikaInputStream.get(path, metadata);
        return this.parse(tikaInputStream, metadata);
    }

    public Reader parse(Path path) throws IOException {
        return this.parse(path, new Metadata());
    }

    public Reader parse(File file, Metadata metadata) throws IOException {
        TikaInputStream tikaInputStream = TikaInputStream.get(file, metadata);
        return this.parse(tikaInputStream, metadata);
    }

    public Reader parse(File file) throws IOException {
        return this.parse(file, new Metadata());
    }

    public Reader parse(URL uRL) throws IOException {
        Metadata metadata = new Metadata();
        TikaInputStream tikaInputStream = TikaInputStream.get(uRL, metadata);
        return this.parse(tikaInputStream, metadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String parseToString(InputStream inputStream, Metadata metadata) throws IOException, TikaException {
        WriteOutContentHandler writeOutContentHandler = new WriteOutContentHandler(this.maxStringLength);
        try {
            ParseContext parseContext = new ParseContext();
            parseContext.set(Parser.class, this.parser);
            this.parser.parse(inputStream, new BodyContentHandler(writeOutContentHandler), metadata, parseContext);
        }
        catch (SAXException sAXException) {
            if (!writeOutContentHandler.isWriteLimitReached(sAXException)) {
                throw new TikaException("Unexpected SAX processing failure", sAXException);
            }
        }
        finally {
            inputStream.close();
        }
        return writeOutContentHandler.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String parseToString(InputStream inputStream, Metadata metadata, int n) throws IOException, TikaException {
        WriteOutContentHandler writeOutContentHandler = new WriteOutContentHandler(n);
        try {
            ParseContext parseContext = new ParseContext();
            parseContext.set(Parser.class, this.parser);
            this.parser.parse(inputStream, new BodyContentHandler(writeOutContentHandler), metadata, parseContext);
        }
        catch (SAXException sAXException) {
            if (!writeOutContentHandler.isWriteLimitReached(sAXException)) {
                throw new TikaException("Unexpected SAX processing failure", sAXException);
            }
        }
        finally {
            inputStream.close();
        }
        return writeOutContentHandler.toString();
    }

    public String parseToString(InputStream inputStream) throws IOException, TikaException {
        return this.parseToString(inputStream, new Metadata());
    }

    public String parseToString(Path path) throws IOException, TikaException {
        Metadata metadata = new Metadata();
        TikaInputStream tikaInputStream = TikaInputStream.get(path, metadata);
        return this.parseToString(tikaInputStream, metadata);
    }

    public String parseToString(File file) throws IOException, TikaException {
        Metadata metadata = new Metadata();
        TikaInputStream tikaInputStream = TikaInputStream.get(file, metadata);
        return this.parseToString(tikaInputStream, metadata);
    }

    public String parseToString(URL uRL) throws IOException, TikaException {
        Metadata metadata = new Metadata();
        TikaInputStream tikaInputStream = TikaInputStream.get(uRL, metadata);
        return this.parseToString(tikaInputStream, metadata);
    }

    public int getMaxStringLength() {
        return this.maxStringLength;
    }

    public void setMaxStringLength(int n) {
        this.maxStringLength = n;
    }

    public Parser getParser() {
        return this.parser;
    }

    public Detector getDetector() {
        return this.detector;
    }

    public Translator getTranslator() {
        return this.translator;
    }

    public String toString() {
        String string = null;
        try (InputStream inputStream = Tika.class.getResourceAsStream("/META-INF/maven/org.apache.tika/tika-core/pom.properties");){
            if (inputStream != null) {
                Properties properties = new Properties();
                properties.load(inputStream);
                string = properties.getProperty("version");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string != null) {
            return "Apache Tika " + string;
        }
        return "Apache Tika";
    }
}

