/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.config;

import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.tika.config.LoadErrorHandler;
import org.apache.tika.config.ServiceLoader;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.detect.CompositeDetector;
import org.apache.tika.detect.DefaultDetector;
import org.apache.tika.detect.Detector;
import org.apache.tika.language.translate.DefaultTranslator;
import org.apache.tika.language.translate.Translator;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.CompositeParser;
import org.apache.tika.parser.DefaultParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.ParserDecorator;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TikaConfigSerializer {
    public static void serialize(TikaConfig tikaConfig, Mode mode, Writer writer, Charset charset) throws Exception {
        DocumentBuilder documentBuilder = new ParseContext().getDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element element = document.createElement("properties");
        document.appendChild(element);
        TikaConfigSerializer.addMimeComment(mode, element, document);
        TikaConfigSerializer.addServiceLoader(mode, element, document, tikaConfig);
        TikaConfigSerializer.addExecutorService(mode, element, document, tikaConfig);
        TikaConfigSerializer.addTranslator(mode, element, document, tikaConfig);
        TikaConfigSerializer.addDetectors(mode, element, document, tikaConfig);
        TikaConfigSerializer.addParsers(mode, element, document, tikaConfig);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        transformer.setOutputProperty("encoding", charset.name());
        DOMSource dOMSource = new DOMSource(document);
        StreamResult streamResult = new StreamResult(writer);
        transformer.transform(dOMSource, streamResult);
    }

    private static void addExecutorService(Mode mode, Element element, Document document, TikaConfig tikaConfig) {
    }

    private static void addServiceLoader(Mode mode, Element element, Document document, TikaConfig tikaConfig) {
        ServiceLoader serviceLoader = tikaConfig.getServiceLoader();
        if (mode == Mode.MINIMAL && serviceLoader.isDynamic() && serviceLoader.getLoadErrorHandler() == LoadErrorHandler.IGNORE) {
            return;
        }
        Element element2 = document.createElement("service-loader");
        element2.setAttribute("dynamic", Boolean.toString(serviceLoader.isDynamic()));
        element2.setAttribute("loadErrorHandler", serviceLoader.getLoadErrorHandler().toString());
        element.appendChild(element2);
    }

    private static void addTranslator(Mode mode, Element element, Document document, TikaConfig tikaConfig) {
        Translator translator = tikaConfig.getTranslator();
        if (mode == Mode.MINIMAL && translator instanceof DefaultTranslator) {
            Comment comment = document.createComment("for example: <translator class=\"org.apache.tika.language.translate.GoogleTranslator\"/>");
            element.appendChild(comment);
        } else {
            if (translator instanceof DefaultTranslator && mode == Mode.STATIC) {
                translator = ((DefaultTranslator)translator).getTranslator();
            }
            if (translator != null) {
                Element element2 = document.createElement("translator");
                element2.setAttribute("class", translator.getClass().getCanonicalName());
                element.appendChild(element2);
            } else {
                element.appendChild(document.createComment("No translators available"));
            }
        }
    }

    private static void addMimeComment(Mode mode, Element element, Document document) {
        Comment comment = document.createComment("for example: <mimeTypeRepository resource=\"/org/apache/tika/mime/tika-mimetypes.xml\"/>");
        element.appendChild(comment);
    }

    private static void addDetectors(Mode mode, Element element, Document document, TikaConfig tikaConfig) throws Exception {
        Detector detector = tikaConfig.getDetector();
        if (mode == Mode.MINIMAL && detector instanceof DefaultDetector) {
            Comment comment = document.createComment("for example: <detectors><detector class=\"org.apache.tika.detector.MimeTypes\"></detectors>");
            element.appendChild(comment);
            return;
        }
        Element element2 = document.createElement("detectors");
        if (mode == Mode.CURRENT && detector instanceof DefaultDetector || !(detector instanceof CompositeDetector)) {
            Element element3 = document.createElement("detector");
            element3.setAttribute("class", detector.getClass().getCanonicalName());
            element2.appendChild(element3);
        } else {
            List<Detector> list = ((CompositeDetector)detector).getDetectors();
            for (Detector detector2 : list) {
                Element element4 = document.createElement("detector");
                element4.setAttribute("class", detector2.getClass().getCanonicalName());
                element2.appendChild(element4);
            }
        }
        element.appendChild(element2);
    }

    private static void addParsers(Mode mode, Element element, Document document, TikaConfig tikaConfig) throws Exception {
        Parser parser = tikaConfig.getParser();
        if (mode == Mode.MINIMAL && parser instanceof DefaultParser) {
            return;
        }
        if (mode == Mode.MINIMAL) {
            mode = Mode.CURRENT;
        }
        Element element2 = document.createElement("parsers");
        element.appendChild(element2);
        TikaConfigSerializer.addParser(mode, element2, document, parser);
    }

    private static void addParser(Mode mode, Element element, Document document, Parser parser) throws Exception {
        ParserDecorator parserDecorator = null;
        if (parser instanceof ParserDecorator && parser.getClass().getName().startsWith(ParserDecorator.class.getName() + "$")) {
            parserDecorator = (ParserDecorator)parser;
            parser = parserDecorator.getWrappedParser();
        }
        boolean bl = true;
        List<Object> list = Collections.emptyList();
        if ((mode != Mode.CURRENT || !(parser instanceof DefaultParser)) && parser instanceof CompositeParser) {
            list = ((CompositeParser)parser).getAllComponentParsers();
            if (parser.getClass().equals(CompositeParser.class)) {
                bl = false;
            }
            if (mode == Mode.STATIC && parser instanceof DefaultParser) {
                bl = false;
            }
        }
        if (bl) {
            element = TikaConfigSerializer.addParser(element, document, parser, parserDecorator);
        }
        for (Parser parser2 : list) {
            TikaConfigSerializer.addParser(mode, element, document, parser2);
        }
    }

    private static Element addParser(Element element, Document document, Parser parser, ParserDecorator parserDecorator) throws Exception {
        Element element2;
        Object object;
        ParseContext parseContext = new ParseContext();
        TreeSet treeSet = new TreeSet();
        TreeSet<MediaType> treeSet2 = new TreeSet<MediaType>();
        if (parserDecorator != null) {
            object = new TreeSet();
            object.addAll(parserDecorator.getSupportedTypes(parseContext));
            treeSet.addAll(object);
            for (MediaType object2 : parser.getSupportedTypes(parseContext)) {
                if (!object.contains(object2)) {
                    treeSet2.add(object2);
                }
                treeSet.remove(object2);
            }
        }
        object = parser.getClass().getCanonicalName();
        Element element3 = document.createElement("parser");
        element3.setAttribute("class", (String)object);
        element.appendChild(element3);
        for (MediaType mediaType : treeSet) {
            element2 = document.createElement("mime");
            element2.appendChild(document.createTextNode(mediaType.toString()));
            element3.appendChild(element2);
        }
        for (MediaType mediaType : treeSet2) {
            element2 = document.createElement("mime-exclude");
            element2.appendChild(document.createTextNode(mediaType.toString()));
            element3.appendChild(element2);
        }
        return element3;
    }

    public static enum Mode {
        MINIMAL,
        CURRENT,
        STATIC;

    }
}

