/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.detect;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.tika.config.LoadErrorHandler;
import org.apache.tika.config.ServiceLoader;
import org.apache.tika.detect.EncodingDetector;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.utils.CharsetUtils;
import org.xml.sax.InputSource;

public class AutoDetectReader
extends BufferedReader {
    private static final ServiceLoader DEFAULT_LOADER = new ServiceLoader(AutoDetectReader.class.getClassLoader());
    private final Charset charset;

    private static Charset detect(InputStream inputStream, Metadata metadata, List<EncodingDetector> list, LoadErrorHandler loadErrorHandler) throws IOException, TikaException {
        String string;
        for (EncodingDetector object2 : list) {
            try {
                Charset noClassDefFoundError = object2.detect(inputStream, metadata);
                if (noClassDefFoundError == null) continue;
                return noClassDefFoundError;
            }
            catch (NoClassDefFoundError exception) {
                loadErrorHandler.handleLoadError(object2.getClass().getName(), exception);
            }
        }
        MediaType mediaType = MediaType.parse(metadata.get("Content-Type"));
        if (mediaType != null && (string = mediaType.getParameters().get("charset")) != null) {
            try {
                return CharsetUtils.forName(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new TikaException("Failed to detect the character encoding of a document");
    }

    private AutoDetectReader(InputStream inputStream, Charset charset) throws IOException {
        super(new InputStreamReader(inputStream, charset));
        this.charset = charset;
        this.mark(1);
        if (this.read() != 65279) {
            this.reset();
        }
    }

    private AutoDetectReader(BufferedInputStream bufferedInputStream, Metadata metadata, List<EncodingDetector> list, LoadErrorHandler loadErrorHandler) throws IOException, TikaException {
        this((InputStream)bufferedInputStream, AutoDetectReader.detect(bufferedInputStream, metadata, list, loadErrorHandler));
    }

    public AutoDetectReader(InputStream inputStream, Metadata metadata, ServiceLoader serviceLoader) throws IOException, TikaException {
        this(new BufferedInputStream(inputStream), metadata, serviceLoader.loadServiceProviders(EncodingDetector.class), serviceLoader.getLoadErrorHandler());
    }

    public AutoDetectReader(InputStream inputStream, Metadata metadata) throws IOException, TikaException {
        this(new BufferedInputStream(inputStream), metadata, DEFAULT_LOADER);
    }

    public AutoDetectReader(InputStream inputStream) throws IOException, TikaException {
        this(inputStream, new Metadata());
    }

    public Charset getCharset() {
        return this.charset;
    }

    public InputSource asInputSource() {
        InputSource inputSource = new InputSource(this);
        inputSource.setEncoding(this.charset.name());
        return inputSource;
    }
}

