/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.detect;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.tika.detect.Detector;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MediaTypeRegistry;

public class CompositeDetector
implements Detector {
    private static final long serialVersionUID = 5980683158436430252L;
    private final MediaTypeRegistry registry;
    private final List<Detector> detectors;

    public CompositeDetector(MediaTypeRegistry mediaTypeRegistry, List<Detector> list, Collection<Class<? extends Detector>> collection) {
        if (collection == null || collection.isEmpty()) {
            this.detectors = list;
        } else {
            this.detectors = new ArrayList<Detector>();
            for (Detector detector : list) {
                if (this.isExcluded(collection, detector.getClass())) continue;
                this.detectors.add(detector);
            }
        }
        this.registry = mediaTypeRegistry;
    }

    public CompositeDetector(MediaTypeRegistry mediaTypeRegistry, List<Detector> list) {
        this(mediaTypeRegistry, list, null);
    }

    public CompositeDetector(List<Detector> list) {
        this(new MediaTypeRegistry(), list);
    }

    public CompositeDetector(Detector ... detectorArray) {
        this(Arrays.asList(detectorArray));
    }

    @Override
    public MediaType detect(InputStream inputStream, Metadata metadata) throws IOException {
        MediaType mediaType = MediaType.OCTET_STREAM;
        for (Detector detector : this.getDetectors()) {
            MediaType mediaType2 = detector.detect(inputStream, metadata);
            if (!this.registry.isSpecializationOf(mediaType2, mediaType)) continue;
            mediaType = mediaType2;
        }
        return mediaType;
    }

    public List<Detector> getDetectors() {
        return Collections.unmodifiableList(this.detectors);
    }

    private boolean isExcluded(Collection<Class<? extends Detector>> collection, Class<? extends Detector> clazz) {
        return collection.contains(clazz) || this.assignableFrom(collection, clazz);
    }

    private boolean assignableFrom(Collection<Class<? extends Detector>> collection, Class<? extends Detector> clazz) {
        for (Class<? extends Detector> clazz2 : collection) {
            if (!clazz2.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }
}

