/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.detect;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tika.detect.Detector;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;

public class MagicDetector
implements Detector {
    private final MediaType type;
    private final int length;
    private final byte[] pattern;
    private final int patternLength;
    private final boolean isRegex;
    private final boolean isStringIgnoreCase;
    private final byte[] mask;
    private final int offsetRangeBegin;
    private final int offsetRangeEnd;

    public static MagicDetector parse(MediaType mediaType, String string, String string2, String string3, String string4) {
        int n = 0;
        int n2 = 0;
        if (string2 != null) {
            int n3 = string2.indexOf(58);
            if (n3 == -1) {
                n2 = n = Integer.parseInt(string2);
            } else {
                n = Integer.parseInt(string2.substring(0, n3));
                n2 = Integer.parseInt(string2.substring(n3 + 1));
            }
        }
        byte[] byArray = MagicDetector.decodeValue(string3, string);
        byte[] byArray2 = null;
        if (string4 != null) {
            byArray2 = MagicDetector.decodeValue(string4, string);
        }
        return new MagicDetector(mediaType, byArray, byArray2, string.equals("regex"), string.equals("stringignorecase"), n, n2);
    }

    private static byte[] decodeValue(String string, String string2) {
        if (string == null || string2 == null) {
            return null;
        }
        byte[] byArray = null;
        String string3 = null;
        int n = 8;
        if (string.startsWith("0x")) {
            string3 = string.substring(2);
            n = 16;
        } else {
            string3 = string;
            n = 8;
        }
        if (string2.equals("string") || string2.equals("regex") || string2.equals("unicodeLE") || string2.equals("unicodeBE")) {
            byArray = MagicDetector.decodeString(string, string2);
        } else if (string2.equals("stringignorecase")) {
            byArray = MagicDetector.decodeString(string.toLowerCase(Locale.ROOT), string2);
        } else if (string2.equals("byte")) {
            byArray = string3.getBytes(StandardCharsets.UTF_8);
        } else if (string2.equals("host16") || string2.equals("little16")) {
            int n2 = Integer.parseInt(string3, n);
            byArray = new byte[]{(byte)(n2 & 0xFF), (byte)(n2 >> 8)};
        } else if (string2.equals("big16")) {
            int n3 = Integer.parseInt(string3, n);
            byArray = new byte[]{(byte)(n3 >> 8), (byte)(n3 & 0xFF)};
        } else if (string2.equals("host32") || string2.equals("little32")) {
            long l = Long.parseLong(string3, n);
            byArray = new byte[]{(byte)(l & 0xFFL), (byte)((l & 0xFF00L) >> 8), (byte)((l & 0xFF0000L) >> 16), (byte)((l & 0xFFFFFFFFFF000000L) >> 24)};
        } else if (string2.equals("big32")) {
            long l = Long.parseLong(string3, n);
            byArray = new byte[]{(byte)((l & 0xFFFFFFFFFF000000L) >> 24), (byte)((l & 0xFF0000L) >> 16), (byte)((l & 0xFF00L) >> 8), (byte)(l & 0xFFL)};
        }
        return byArray;
    }

    private static byte[] decodeString(String string, String string2) {
        byte[] byArray;
        if (string.startsWith("0x")) {
            byte[] byArray2 = new byte[(string.length() - 2) / 2];
            for (int i = 0; i < byArray2.length; ++i) {
                byArray2[i] = (byte)Integer.parseInt(string.substring(2 + i * 2, 4 + i * 2), 16);
            }
            return byArray2;
        }
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '\\') {
                int n;
                if (string.charAt(i + 1) == '\\') {
                    charArrayWriter.write(92);
                    ++i;
                    continue;
                }
                if (string.charAt(i + 1) == 'x') {
                    charArrayWriter.write(Integer.parseInt(string.substring(i + 2, i + 4), 16));
                    i += 3;
                    continue;
                }
                if (string.charAt(i + 1) == 'r') {
                    charArrayWriter.write(13);
                    ++i;
                    continue;
                }
                if (string.charAt(i + 1) == 'n') {
                    charArrayWriter.write(10);
                    ++i;
                    continue;
                }
                for (n = i + 1; n < i + 4 && n < string.length() && Character.isDigit(string.charAt(n)); ++n) {
                }
                charArrayWriter.write(Short.decode("0" + string.substring(i + 1, n)).byteValue());
                i = n - 1;
                continue;
            }
            charArrayWriter.write(string.charAt(i));
        }
        char[] cArray = charArrayWriter.toCharArray();
        if ("unicodeLE".equals(string2)) {
            byArray = new byte[cArray.length * 2];
            for (int i = 0; i < cArray.length; ++i) {
                byArray[i * 2] = (byte)(cArray[i] & 0xFF);
                byArray[i * 2 + 1] = (byte)(cArray[i] >> 8);
            }
        } else if ("unicodeBE".equals(string2)) {
            byArray = new byte[cArray.length * 2];
            for (int i = 0; i < cArray.length; ++i) {
                byArray[i * 2] = (byte)(cArray[i] >> 8);
                byArray[i * 2 + 1] = (byte)(cArray[i] & 0xFF);
            }
        } else {
            byArray = new byte[cArray.length];
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = (byte)cArray[i];
            }
        }
        return byArray;
    }

    public MagicDetector(MediaType mediaType, byte[] byArray) {
        this(mediaType, byArray, 0);
    }

    public MagicDetector(MediaType mediaType, byte[] byArray, int n) {
        this(mediaType, byArray, null, n, n);
    }

    public MagicDetector(MediaType mediaType, byte[] byArray, byte[] byArray2, int n, int n2) {
        this(mediaType, byArray, byArray2, false, n, n2);
    }

    public MagicDetector(MediaType mediaType, byte[] byArray, byte[] byArray2, boolean bl, int n, int n2) {
        this(mediaType, byArray, byArray2, bl, false, n, n2);
    }

    public MagicDetector(MediaType mediaType, byte[] byArray, byte[] byArray2, boolean bl, boolean bl2, int n, int n2) {
        if (mediaType == null) {
            throw new IllegalArgumentException("Matching media type is null");
        }
        if (byArray == null) {
            throw new IllegalArgumentException("Magic match pattern is null");
        }
        if (n < 0 || n2 < n) {
            throw new IllegalArgumentException("Invalid offset range: [" + n + "," + n2 + "]");
        }
        this.type = mediaType;
        this.isRegex = bl;
        this.isStringIgnoreCase = bl2;
        this.patternLength = Math.max(byArray.length, byArray2 != null ? byArray2.length : 0);
        this.length = this.isRegex ? 8192 : this.patternLength;
        this.mask = new byte[this.patternLength];
        this.pattern = new byte[this.patternLength];
        for (int i = 0; i < this.patternLength; ++i) {
            this.mask[i] = byArray2 != null && i < byArray2.length ? byArray2[i] : -1;
            this.pattern[i] = i < byArray.length ? (byte)(byArray[i] & this.mask[i]) : (byte)0;
        }
        this.offsetRangeBegin = n;
        this.offsetRangeEnd = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MediaType detect(InputStream inputStream, Metadata metadata) throws IOException {
        if (inputStream == null) {
            return MediaType.OCTET_STREAM;
        }
        inputStream.mark(this.offsetRangeEnd + this.length);
        try {
            int n;
            int n2 = 0;
            while (n2 < this.offsetRangeBegin) {
                long l = inputStream.skip(this.offsetRangeBegin - n2);
                if (l > 0L) {
                    n2 = (int)((long)n2 + l);
                    continue;
                }
                if (inputStream.read() != -1) {
                    ++n2;
                    continue;
                }
                MediaType mediaType = MediaType.OCTET_STREAM;
                return mediaType;
            }
            byte[] byArray = new byte[this.length + (this.offsetRangeEnd - this.offsetRangeBegin)];
            int n3 = inputStream.read(byArray);
            if (n3 > 0) {
                n2 += n3;
            }
            while (n3 != -1 && n2 < this.offsetRangeEnd + this.length) {
                n = n2 - this.offsetRangeBegin;
                n3 = inputStream.read(byArray, n, byArray.length - n);
                if (n3 <= 0) continue;
                n2 += n3;
            }
            if (this.isRegex) {
                n = 0;
                if (this.isStringIgnoreCase) {
                    n = 2;
                }
                Pattern pattern = Pattern.compile(new String(this.pattern, StandardCharsets.UTF_8), n);
                ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
                CharBuffer charBuffer = StandardCharsets.ISO_8859_1.decode(byteBuffer);
                Matcher matcher = pattern.matcher(charBuffer);
                boolean bl = false;
                for (int i = 0; i <= this.offsetRangeEnd - this.offsetRangeBegin; ++i) {
                    matcher.region(i, this.length + i);
                    bl = matcher.lookingAt();
                    if (!bl) continue;
                    MediaType mediaType = this.type;
                    return mediaType;
                }
            } else {
                if (n2 < this.offsetRangeBegin + this.length) {
                    MediaType mediaType = MediaType.OCTET_STREAM;
                    return mediaType;
                }
                for (n = 0; n <= this.offsetRangeEnd - this.offsetRangeBegin; ++n) {
                    boolean bl = true;
                    for (int i = 0; bl && i < this.length; ++i) {
                        int n4 = byArray[n + i] & this.mask[i];
                        if (this.isStringIgnoreCase) {
                            n4 = Character.toLowerCase(n4);
                        }
                        bl = n4 == this.pattern[i];
                    }
                    if (!bl) continue;
                    MediaType mediaType = this.type;
                    return mediaType;
                }
            }
            MediaType mediaType = MediaType.OCTET_STREAM;
            return mediaType;
        }
        finally {
            inputStream.reset();
        }
    }

    public int getLength() {
        return this.patternLength;
    }

    public String toString() {
        return "Magic Detection for " + String.valueOf(this.type) + " looking for " + this.pattern.length + " bytes = " + String.valueOf(this.pattern) + " mask = " + String.valueOf(this.mask);
    }
}

