/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.detect;

import org.apache.tika.detect.TrainedModel;

public class NNTrainedModel
extends TrainedModel {
    private int numOfInputs;
    private int numOfHidden;
    private int numOfOutputs;
    private float[][] Theta1;
    private float[][] Theta2;

    public NNTrainedModel(int n, int n2, int n3, float[] fArray) {
        this.numOfInputs = n;
        this.numOfHidden = n2;
        this.numOfOutputs = n3;
        this.Theta1 = new float[this.numOfHidden][this.numOfInputs + 1];
        this.Theta2 = new float[this.numOfOutputs][this.numOfHidden + 1];
        this.populateThetas(fArray);
    }

    private void populateThetas(float[] fArray) {
        int n;
        int n2;
        int n3 = this.Theta1.length;
        int n4 = this.Theta1[0].length;
        int n5 = 0;
        for (n2 = 0; n2 < n4; ++n2) {
            for (n = 0; n < n3; ++n) {
                this.Theta1[n][n2] = fArray[n5];
                ++n5;
            }
        }
        n3 = this.Theta2.length;
        n4 = this.Theta2[0].length;
        for (n2 = 0; n2 < n4; ++n2) {
            for (n = 0; n < n3; ++n) {
                this.Theta2[n][n2] = fArray[n5];
                ++n5;
            }
        }
    }

    @Override
    public double predict(double[] dArray) {
        return 0.0;
    }

    @Override
    public float predict(float[] fArray) {
        int n;
        int n2;
        int n3 = this.Theta1.length;
        int n4 = this.Theta1[0].length;
        float[] fArray2 = new float[n3 + 1];
        fArray2[0] = 1.0f;
        for (n2 = 0; n2 < n3; ++n2) {
            double d = 0.0;
            for (n = 0; n < n4; ++n) {
                d += (double)(this.Theta1[n2][n] * fArray[n]);
            }
            d = 1.0 / (1.0 + Math.exp(-d));
            fArray2[n2 + 1] = (float)d;
        }
        n3 = this.Theta2.length;
        n4 = this.Theta2[0].length;
        float[] fArray3 = new float[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            double d = 0.0;
            for (n = 0; n < n4; ++n) {
                d += (double)(this.Theta2[n2][n] * fArray2[n]);
            }
            d = 1.0 / (1.0 + Math.exp(-d));
            fArray3[n2] = (float)d;
        }
        return fArray3[0];
    }
}

