/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.detect;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.tika.detect.Detector;
import org.apache.tika.detect.TrainedModel;
import org.apache.tika.io.TemporaryResources;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;

public abstract class TrainedModelDetector
implements Detector {
    private final Map<MediaType, TrainedModel> MODEL_MAP = new HashMap<MediaType, TrainedModel>();
    private static final long serialVersionUID = 1L;

    public TrainedModelDetector() {
        this.loadDefaultModels(this.getClass().getClassLoader());
    }

    public int getMinLength() {
        return Integer.MAX_VALUE;
    }

    @Override
    public MediaType detect(InputStream inputStream, Metadata metadata) throws IOException {
        if (inputStream != null) {
            float f;
            inputStream.mark(this.getMinLength());
            float[] fArray = this.readByteFrequencies(inputStream);
            Iterator<MediaType> iterator = this.MODEL_MAP.keySet().iterator();
            float f2 = f = 0.5f;
            MediaType mediaType = MediaType.OCTET_STREAM;
            while (iterator.hasNext()) {
                MediaType mediaType2 = iterator.next();
                TrainedModel trainedModel = this.MODEL_MAP.get(mediaType2);
                float f3 = trainedModel.predict(fArray);
                if (!(f2 < f3)) continue;
                f2 = f3;
                mediaType = mediaType2;
            }
            inputStream.reset();
            return mediaType;
        }
        return null;
    }

    protected float[] readByteFrequencies(InputStream inputStream) throws IOException {
        int n;
        ReadableByteChannel readableByteChannel = Channels.newChannel(inputStream);
        float[] fArray = new float[257];
        fArray[0] = 1.0f;
        ByteBuffer byteBuffer = ByteBuffer.allocate(5120);
        int n2 = readableByteChannel.read(byteBuffer);
        float f = -1.0f;
        while (n2 != -1) {
            byteBuffer.flip();
            while (byteBuffer.hasRemaining()) {
                int n3 = n = (int)byteBuffer.get();
                ++n3;
                if (n < 0) {
                    int n4 = n3 = 256 + n3;
                    fArray[n4] = fArray[n4] + 1.0f;
                } else {
                    int n5 = n3;
                    fArray[n5] = fArray[n5] + 1.0f;
                }
                f = f < fArray[n3] ? fArray[n3] : f;
            }
            byteBuffer.clear();
            n2 = readableByteChannel.read(byteBuffer);
        }
        for (n = 1; n < fArray.length; ++n) {
            int n6 = n;
            fArray[n6] = fArray[n6] / f;
            fArray[n] = (float)Math.sqrt(fArray[n]);
        }
        return fArray;
    }

    private void writeHisto(float[] fArray) throws IOException {
        Path path = new TemporaryResources().createTempFile();
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
            for (float f : fArray) {
                bufferedWriter.write(String.valueOf(f) + "\t");
            }
            bufferedWriter.write("\r\n");
        }
    }

    public void loadDefaultModels(Path path) {
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
            this.loadDefaultModels(inputStream);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to read the default media type registry", iOException);
        }
    }

    public void loadDefaultModels(File file) {
        this.loadDefaultModels(file.toPath());
    }

    public abstract void loadDefaultModels(InputStream var1);

    public abstract void loadDefaultModels(ClassLoader var1);

    protected void registerModels(MediaType mediaType, TrainedModel trainedModel) {
        this.MODEL_MAP.put(mediaType, trainedModel);
    }
}

