/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.extractor;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.detect.DefaultDetector;
import org.apache.tika.detect.Detector;
import org.apache.tika.exception.TikaException;
import org.apache.tika.extractor.ContainerExtractor;
import org.apache.tika.extractor.EmbeddedResourceHandler;
import org.apache.tika.io.TemporaryResources;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ParserContainerExtractor
implements ContainerExtractor {
    private static final long serialVersionUID = 2261131045580861514L;
    private final Parser parser;
    private final Detector detector;

    public ParserContainerExtractor() {
        this(TikaConfig.getDefaultConfig());
    }

    public ParserContainerExtractor(TikaConfig tikaConfig) {
        this(new AutoDetectParser(tikaConfig), new DefaultDetector(tikaConfig.getMimeRepository()));
    }

    public ParserContainerExtractor(Parser parser, Detector detector) {
        this.parser = parser;
        this.detector = detector;
    }

    @Override
    public boolean isSupported(TikaInputStream tikaInputStream) throws IOException {
        MediaType mediaType = this.detector.detect(tikaInputStream, new Metadata());
        return this.parser.getSupportedTypes(new ParseContext()).contains(mediaType);
    }

    @Override
    public void extract(TikaInputStream tikaInputStream, ContainerExtractor containerExtractor, EmbeddedResourceHandler embeddedResourceHandler) throws IOException, TikaException {
        ParseContext parseContext = new ParseContext();
        parseContext.set(Parser.class, new RecursiveParser(containerExtractor, embeddedResourceHandler));
        try {
            this.parser.parse(tikaInputStream, new DefaultHandler(), new Metadata(), parseContext);
        }
        catch (SAXException sAXException) {
            throw new TikaException("Unexpected SAX exception", sAXException);
        }
    }

    private class RecursiveParser
    extends AbstractParser {
        private final ContainerExtractor extractor;
        private final EmbeddedResourceHandler handler;

        private RecursiveParser(ContainerExtractor containerExtractor, EmbeddedResourceHandler embeddedResourceHandler) {
            this.extractor = containerExtractor;
            this.handler = embeddedResourceHandler;
        }

        @Override
        public Set<MediaType> getSupportedTypes(ParseContext parseContext) {
            return ParserContainerExtractor.this.parser.getSupportedTypes(parseContext);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void parse(InputStream inputStream, ContentHandler contentHandler, Metadata metadata, ParseContext parseContext) throws IOException, SAXException, TikaException {
            block10: {
                TemporaryResources temporaryResources = new TemporaryResources();
                try {
                    TikaInputStream tikaInputStream = TikaInputStream.get(inputStream, temporaryResources);
                    String string = metadata.get("resourceName");
                    MediaType mediaType = ParserContainerExtractor.this.detector.detect(tikaInputStream, metadata);
                    if (this.extractor == null) {
                        this.handler.handle(string, mediaType, tikaInputStream);
                        break block10;
                    }
                    File file = tikaInputStream.getFile();
                    try (TikaInputStream tikaInputStream2 = TikaInputStream.get(file);){
                        this.handler.handle(string, mediaType, tikaInputStream2);
                    }
                    this.extractor.extract(tikaInputStream, this.extractor, this.handler);
                }
                finally {
                    temporaryResources.dispose();
                }
            }
        }
    }
}

