/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.io;

import java.io.IOException;
import java.io.InputStream;
import org.apache.tika.io.ProxyInputStream;

public class CountingInputStream
extends ProxyInputStream {
    private long count;

    public CountingInputStream(InputStream inputStream) {
        super(inputStream);
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        int n = super.read(byArray);
        this.count += n >= 0 ? (long)n : 0L;
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = super.read(byArray, n, n2);
        this.count += n3 >= 0 ? (long)n3 : 0L;
        return n3;
    }

    @Override
    public int read() throws IOException {
        int n = super.read();
        this.count += n >= 0 ? 1L : 0L;
        return n;
    }

    @Override
    public long skip(long l) throws IOException {
        long l2 = super.skip(l);
        this.count += l2;
        return l2;
    }

    public synchronized int getCount() {
        long l = this.getByteCount();
        if (l > Integer.MAX_VALUE) {
            throw new ArithmeticException("The byte count " + l + " is too large to be converted to an int");
        }
        return (int)l;
    }

    public synchronized int resetCount() {
        long l = this.resetByteCount();
        if (l > Integer.MAX_VALUE) {
            throw new ArithmeticException("The byte count " + l + " is too large to be converted to an int");
        }
        return (int)l;
    }

    public synchronized long getByteCount() {
        return this.count;
    }

    public synchronized long resetByteCount() {
        long l = this.count;
        this.count = 0L;
        return l;
    }

    public String toString() {
        return "Tika Counting InputStream wrapping " + this.in.toString();
    }
}

