/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.io;

import java.util.HashSet;
import java.util.Locale;

public class FilenameUtils {
    public static final char[] RESERVED_FILENAME_CHARACTERS = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', '?', ':', '*', '<', '>', '|'};
    private static final HashSet<Character> RESERVED = new HashSet(38);

    public static String normalize(String string) {
        if (string == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (char c : string.toCharArray()) {
            if (RESERVED.contains(Character.valueOf(c))) {
                stringBuilder.append('%').append(c < '\u0010' ? "0" : "").append(Integer.toHexString(c).toUpperCase(Locale.ROOT));
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String getName(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        int n = string.lastIndexOf("/");
        int n2 = string.lastIndexOf("\\");
        int n3 = string.lastIndexOf(":");
        String string2 = string.substring(Math.max(n3, Math.max(n, n2)) + 1);
        if (string2.equals("..") || string2.equals(".")) {
            return "";
        }
        return string2;
    }

    static {
        for (int i = 0; i < RESERVED_FILENAME_CHARACTERS.length; ++i) {
            RESERVED.add(Character.valueOf(RESERVED_FILENAME_CHARACTERS[i]));
        }
    }
}

