/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.UUID;
import org.apache.tika.io.ProxyInputStream;
import org.apache.tika.io.TaggedIOException;

public class TaggedInputStream
extends ProxyInputStream {
    private final Serializable tag = UUID.randomUUID();

    public TaggedInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public static TaggedInputStream get(InputStream inputStream) {
        if (inputStream instanceof TaggedInputStream) {
            return (TaggedInputStream)inputStream;
        }
        return new TaggedInputStream(inputStream);
    }

    public boolean isCauseOf(IOException iOException) {
        if (iOException instanceof TaggedIOException) {
            TaggedIOException taggedIOException = (TaggedIOException)iOException;
            return this.tag.equals(taggedIOException.getTag());
        }
        return false;
    }

    public void throwIfCauseOf(Exception exception) throws IOException {
        TaggedIOException taggedIOException;
        if (exception instanceof TaggedIOException && this.tag.equals((taggedIOException = (TaggedIOException)exception).getTag())) {
            throw taggedIOException.getCause();
        }
    }

    @Override
    protected void handleIOException(IOException iOException) throws IOException {
        throw new TaggedIOException(iOException, this.tag);
    }

    public String toString() {
        return "Tika Tagged InputStream wrapping " + String.valueOf(this.in);
    }
}

