/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class TailStream
extends FilterInputStream {
    private static final int SKIP_SIZE = 4096;
    private final byte[] tailBuffer;
    private final int tailSize;
    private byte[] markBuffer;
    private long bytesRead;
    private long markBytesRead;
    private int currentIndex;
    private int markIndex;

    public TailStream(InputStream inputStream, int n) {
        super(inputStream);
        this.tailSize = n;
        this.tailBuffer = new byte[n];
    }

    @Override
    public int read() throws IOException {
        int n = super.read();
        if (n != -1) {
            this.appendByte((byte)n);
        }
        return n;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        int n = super.read(byArray);
        if (n > 0) {
            this.appendBuf(byArray, 0, n);
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = super.read(byArray, n, n2);
        if (n3 > 0) {
            this.appendBuf(byArray, n, n3);
        }
        return n3;
    }

    @Override
    public long skip(long l) throws IOException {
        int n = (int)Math.min(l, 4096L);
        byte[] byArray = new byte[n];
        long l2 = 0L;
        int n2 = 0;
        while (l2 < l && n2 != -1) {
            int n3 = (int)Math.min((long)n, l - l2);
            n2 = this.read(byArray, 0, n3);
            if (n2 == -1) continue;
            l2 += (long)n2;
        }
        return n2 < 0 && l2 == 0L ? -1L : l2;
    }

    @Override
    public void mark(int n) {
        this.markBuffer = new byte[this.tailSize];
        System.arraycopy(this.tailBuffer, 0, this.markBuffer, 0, this.tailSize);
        this.markIndex = this.currentIndex;
        this.markBytesRead = this.bytesRead;
    }

    @Override
    public void reset() {
        if (this.markBuffer != null) {
            System.arraycopy(this.markBuffer, 0, this.tailBuffer, 0, this.tailSize);
            this.currentIndex = this.markIndex;
            this.bytesRead = this.markBytesRead;
        }
    }

    public byte[] getTail() {
        int n = (int)Math.min((long)this.tailSize, this.bytesRead);
        byte[] byArray = new byte[n];
        System.arraycopy(this.tailBuffer, this.currentIndex, byArray, 0, n - this.currentIndex);
        System.arraycopy(this.tailBuffer, 0, byArray, n - this.currentIndex, this.currentIndex);
        return byArray;
    }

    private void appendByte(byte by) {
        this.tailBuffer[this.currentIndex++] = by;
        if (this.currentIndex >= this.tailSize) {
            this.currentIndex = 0;
        }
        ++this.bytesRead;
    }

    private void appendBuf(byte[] byArray, int n, int n2) {
        if (n2 >= this.tailSize) {
            this.replaceTailBuffer(byArray, n, n2);
        } else {
            this.copyToTailBuffer(byArray, n, n2);
        }
        this.bytesRead += (long)n2;
    }

    private void replaceTailBuffer(byte[] byArray, int n, int n2) {
        System.arraycopy(byArray, n + n2 - this.tailSize, this.tailBuffer, 0, this.tailSize);
        this.currentIndex = 0;
    }

    private void copyToTailBuffer(byte[] byArray, int n, int n2) {
        int n3 = this.tailSize - this.currentIndex;
        int n4 = Math.min(n3, n2);
        System.arraycopy(byArray, n, this.tailBuffer, this.currentIndex, n4);
        System.arraycopy(byArray, n + n4, this.tailBuffer, 0, n2 - n4);
        this.currentIndex = (this.currentIndex + n2) % this.tailSize;
    }
}

